/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate.extension;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.xwiki.crypto.pkix.internal.extension.BcGeneralName;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509StringGeneralName;

public class X509URI
implements X509StringGeneralName,
BcGeneralName {
    private final String str;
    private final URI uri;
    private final URL url;

    public X509URI(String str) {
        String newStr = null;
        URI newUri = null;
        URL newUrl = null;
        try {
            newUri = new URI(str);
            newUrl = newUri.toURL();
            newStr = newUrl.toString();
            newUri = newUrl.toURI();
        }
        catch (URISyntaxException e) {
            try {
                newUrl = new URL(str);
                newStr = newUrl.toString();
            }
            catch (MalformedURLException e1) {
                newStr = str;
            }
        }
        catch (MalformedURLException e) {
            newStr = newUri.toASCIIString();
        }
        this.str = newStr;
        this.uri = newUri;
        this.url = newUrl;
    }

    public X509URI(URL url) {
        this.str = url.toString();
        this.url = url;
        URI newUri = null;
        try {
            newUri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.uri = newUri;
    }

    public X509URI(GeneralName name) {
        this(DERIA5String.getInstance((Object)name.getName()).getString());
        if (name.getTagNo() != 6) {
            throw new IllegalArgumentException("Incompatible general name: " + name.getTagNo());
        }
    }

    public URL getURL() {
        return this.url;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.str;
    }

    @Override
    public GeneralName getGeneralName() {
        return new GeneralName(6, this.str);
    }
}

