/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.pkix.CertificateChainBuilder;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.KeyUsage;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;

@Component
@Singleton
@Named(value="X509")
public class BcX509CertificateChainBuilder
implements CertificateChainBuilder {
    @Override
    public Collection<CertifiedPublicKey> build(CertifiedPublicKey certificate, CertificateProvider provider) {
        if (certificate == null) {
            return null;
        }
        ArrayDeque<CertifiedPublicKey> result = new ArrayDeque<CertifiedPublicKey>();
        this.build(result, certificate, provider);
        return result;
    }

    private Collection<CertifiedPublicKey> build(Deque<CertifiedPublicKey> result, CertifiedPublicKey certificate, CertificateProvider provider) {
        if (result.contains(certificate)) {
            return result;
        }
        if (!(certificate instanceof X509CertifiedPublicKey)) {
            throw new IllegalArgumentException("Certificate of incompatible type [" + certificate.getClass().getName() + "] for subject [" + certificate.getSubject().getName() + "]");
        }
        result.push(certificate);
        CertifiedPublicKey issuer = this.getIssuer((X509CertifiedPublicKey)certificate, provider);
        return issuer != null && !issuer.equals(certificate) ? this.build(result, issuer, provider) : result;
    }

    private CertifiedPublicKey getIssuer(X509CertifiedPublicKey cert, CertificateProvider provider) {
        byte[] authKey;
        X509Extensions extensions = cert.getExtensions();
        if (extensions != null && (authKey = extensions.getAuthorityKeyIdentifier()) != null) {
            if (Arrays.equals(extensions.getSubjectKeyIdentifier(), authKey)) {
                return cert;
            }
            return this.validatedIssuer(cert, provider.getCertificate(authKey));
        }
        Collection<CertifiedPublicKey> certs = provider.getCertificate(cert.getIssuer());
        if (certs != null) {
            for (CertifiedPublicKey issuerCert : certs) {
                CertifiedPublicKey issuer = this.validatedIssuer(cert, issuerCert);
                if (issuer == null) continue;
                return issuer;
            }
        }
        return null;
    }

    private CertifiedPublicKey validatedIssuer(X509CertifiedPublicKey cert, CertifiedPublicKey issuerCert) {
        if (issuerCert == null || !(issuerCert instanceof X509CertifiedPublicKey)) {
            return null;
        }
        X509CertifiedPublicKey issuer = (X509CertifiedPublicKey)issuerCert;
        if (issuer.getVersionNumber() == 3) {
            X509Extensions extensions = issuer.getExtensions();
            if (extensions == null || !extensions.hasCertificateAuthorityBasicConstraints()) {
                return null;
            }
            EnumSet<KeyUsage> usage = extensions.getKeyUsage();
            if (!usage.contains((Object)KeyUsage.keyCertSign)) {
                return null;
            }
        }
        try {
            return cert.isSignedBy(issuer.getPublicKeyParameters()) ? issuer : null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }
}

