/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.pkix.CertificateGenerator;
import org.xwiki.crypto.pkix.CertificateGeneratorFactory;
import org.xwiki.crypto.pkix.internal.BcX509v1CertificateGenerator;
import org.xwiki.crypto.pkix.internal.BcX509v3CertificateGenerator;
import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;

@Component
@Named(value="X509")
@Singleton
public class BcX509CertificateGeneratorFactory
implements CertificateGeneratorFactory {
    @Inject
    private SignerFactory signerFactory;
    @Inject
    private Provider<SecureRandom> randomProvider;

    @Override
    public CertificateGenerator getInstance(Signer signer, CertificateGenerationParameters parameters) {
        if (!(parameters instanceof X509CertificateGenerationParameters)) {
            throw new IllegalArgumentException("Invalid parameters for X.509 certificate: " + parameters.getClass().getName());
        }
        if (!signer.isForSigning()) {
            throw new IllegalArgumentException("Verifying signer used for signing certificates.");
        }
        X509CertificateGenerationParameters params = (X509CertificateGenerationParameters)parameters;
        switch (params.getX509Version()) {
            case V1: {
                return new BcX509v1CertificateGenerator(signer, params, this.signerFactory, (SecureRandom)this.randomProvider.get());
            }
            case V3: {
                return new BcX509v3CertificateGenerator(signer, params, this.signerFactory, (SecureRandom)this.randomProvider.get());
            }
        }
        throw new IllegalArgumentException("Unknown X.509 certificate version: " + params.getX509Version());
    }
}

