/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.x509.Extension;

public class ExtendedKeyUsages {
    public static final String OID = Extension.extendedKeyUsage.getId();
    public static final String ANY_EXTENDED_KEY_USAGE = "2.5.29.37.0";
    public static final String SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    public static final String CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    public static final String CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    public static final String EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    public static final String TIME_STAMPING = "1.3.6.1.5.5.7.3.8";
    public static final String OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    private Set<String> usages = new HashSet<String>();

    public ExtendedKeyUsages(String[] usages) {
        Collections.addAll(this.usages, usages);
    }

    public ExtendedKeyUsages(Collection<String> usages) {
        this.usages.addAll(usages);
    }

    public boolean hasUsage(String usage) {
        return this.usages.contains(usage);
    }

    public Set<String> getAll() {
        return Collections.unmodifiableSet(this.usages);
    }

    public boolean isEmpty() {
        return this.usages.isEmpty();
    }
}

