/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.param;

import java.util.ArrayList;
import java.util.Collection;
import org.xwiki.crypto.pkix.CertifyingSigner;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.param.CMSSignerInfo;

public class CMSSignedDataGeneratorParameters {
    private Collection<CMSSignerInfo> signatures = new ArrayList<CMSSignerInfo>();
    private Collection<CertifyingSigner> signers = new ArrayList<CertifyingSigner>();
    private Collection<CertifiedPublicKey> certificates = new ArrayList<CertifiedPublicKey>();

    public CMSSignedDataGeneratorParameters addSignature(CMSSignerInfo signer) {
        this.signatures.add(signer);
        return this;
    }

    public CMSSignedDataGeneratorParameters addSigner(CertifyingSigner signer) {
        this.signers.add(signer);
        return this;
    }

    public CMSSignedDataGeneratorParameters addSignatures(Collection<CMSSignerInfo> signers) {
        this.signatures.addAll(signers);
        return this;
    }

    public CMSSignedDataGeneratorParameters addSigners(Collection<CertifyingSigner> signers) {
        this.signers.addAll(signers);
        return this;
    }

    public CMSSignedDataGeneratorParameters addCertificate(CertifiedPublicKey certificate) {
        this.certificates.add(certificate);
        return this;
    }

    public CMSSignedDataGeneratorParameters addCertificates(Collection<CertifiedPublicKey> certificates) {
        this.certificates.addAll(certificates);
        return this;
    }

    public Collection<CertifiedPublicKey> getCertificates() {
        return this.certificates;
    }

    public Collection<CMSSignerInfo> getSignatures() {
        return this.signatures;
    }

    public Collection<CertifyingSigner> getSigners() {
        return this.signers;
    }
}

