/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.cms;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.ChainingCertificateProvider;
import org.xwiki.crypto.pkix.internal.BcStoreX509CertificateProvider;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.signer.internal.cms.BcCMSSignedDataVerified;

public final class BcStoreUtils {
    private BcStoreUtils() {
    }

    public static CertificateProvider getCertificateProvider(ComponentManager manager, Store store, CertificateProvider certificateProvider) throws GeneralSecurityException {
        CertificateProvider provider = BcStoreUtils.newCertificateProvider(manager, store);
        if (certificateProvider == null) {
            return provider;
        }
        return new ChainingCertificateProvider(provider, certificateProvider);
    }

    public static void addCertificatesToVerifiedData(Store store, BcCMSSignedDataVerified verifiedData, CertificateFactory certFactory) {
        for (X509CertificateHolder cert : BcStoreUtils.getCertificates(store)) {
            verifiedData.addCertificate(BcUtils.convertCertificate(certFactory, cert));
        }
    }

    public static CertificateProvider getCertificateProvider(ComponentManager manager, Collection<CertifiedPublicKey> certificates) throws GeneralSecurityException {
        if (certificates == null || certificates.isEmpty()) {
            return null;
        }
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(certificates.size());
        for (CertifiedPublicKey cert : certificates) {
            certs.add(BcUtils.getX509CertificateHolder(cert));
        }
        return BcStoreUtils.newCertificateProvider(manager, (Store)new CollectionStore(certs));
    }

    private static CertificateProvider newCertificateProvider(ComponentManager manager, Store store) throws GeneralSecurityException {
        try {
            CertificateProvider provider = (CertificateProvider)manager.getInstance(CertificateProvider.class, "BCStoreX509");
            ((BcStoreX509CertificateProvider)provider).setStore(store);
            return provider;
        }
        catch (ComponentLookupException e) {
            throw new GeneralSecurityException("Unable to initialize the certificates store", e);
        }
    }

    private static Collection<X509CertificateHolder> getCertificates(Store store) {
        return store.getMatches(null);
    }

    public static CertifiedPublicKey getCertificate(CertificateProvider provider, SignerInformation signer, CertificateFactory factory) {
        SignerId id = signer.getSID();
        if (provider instanceof BcStoreX509CertificateProvider) {
            X509CertificateHolder cert = ((BcStoreX509CertificateProvider)provider).getCertificate((Selector)id);
            return cert != null ? BcUtils.convertCertificate(factory, cert) : null;
        }
        X500Name bcIssuer = id.getIssuer();
        BigInteger serial = id.getSerialNumber();
        byte[] keyId = id.getSubjectKeyIdentifier();
        if (bcIssuer != null) {
            DistinguishedName issuer = new DistinguishedName(bcIssuer);
            if (keyId != null) {
                return provider.getCertificate(issuer, serial, keyId);
            }
            return provider.getCertificate(issuer, serial);
        }
        if (keyId != null) {
            return provider.getCertificate(keyId);
        }
        return null;
    }
}

