/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix;

import java.math.BigInteger;
import java.util.Collection;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;

public class ChainingCertificateProvider
implements CertificateProvider {
    private final CertificateProvider[] providers;

    public ChainingCertificateProvider(CertificateProvider ... providers) {
        this.providers = providers;
    }

    @Override
    public CertifiedPublicKey getCertificate(byte[] keyIdentifier) {
        CertificateProvider provider;
        CertifiedPublicKey result = null;
        CertificateProvider[] certificateProviderArray = this.providers;
        int n = certificateProviderArray.length;
        for (int i = 0; i < n && (result = (provider = certificateProviderArray[i]).getCertificate(keyIdentifier)) == null; ++i) {
        }
        return result;
    }

    @Override
    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial) {
        CertificateProvider provider;
        CertifiedPublicKey result = null;
        CertificateProvider[] certificateProviderArray = this.providers;
        int n = certificateProviderArray.length;
        for (int i = 0; i < n && (result = (provider = certificateProviderArray[i]).getCertificate(issuer, serial)) == null; ++i) {
        }
        return result;
    }

    @Override
    public CertifiedPublicKey getCertificate(PrincipalIndentifier issuer, BigInteger serial, byte[] keyIdentifier) {
        CertificateProvider provider;
        CertifiedPublicKey result = null;
        CertificateProvider[] certificateProviderArray = this.providers;
        int n = certificateProviderArray.length;
        for (int i = 0; i < n && (result = (provider = certificateProviderArray[i]).getCertificate(issuer, serial, keyIdentifier)) == null; ++i) {
        }
        return result;
    }

    @Override
    public Collection<CertifiedPublicKey> getCertificate(PrincipalIndentifier subject) {
        CertificateProvider provider;
        Collection<CertifiedPublicKey> result = null;
        CertificateProvider[] certificateProviderArray = this.providers;
        int n = certificateProviderArray.length;
        for (int i = 0; i < n && (result = (provider = certificateProviderArray[i]).getCertificate(subject)) == null; ++i) {
        }
        return result;
    }
}

