/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.pkix.CertifyingSigner;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.CMSSignedDataGenerator;
import org.xwiki.crypto.signer.internal.cms.BcCMSSignerInfo;
import org.xwiki.crypto.signer.param.CMSSignedDataGeneratorParameters;
import org.xwiki.crypto.signer.param.CMSSignerInfo;

@Component
@Singleton
public class DefaultCMSSignedDataGenerator
implements CMSSignedDataGenerator,
Initializable {
    @Inject
    private DigestFactory digestProvider;

    public void initialize() throws InitializationException {
        if (!(this.digestProvider instanceof DigestCalculatorProvider)) {
            throw new InitializationException("Incompatible DigestFactory for this signed data generator.");
        }
    }

    @Override
    public byte[] generate(byte[] data, CMSSignedDataGeneratorParameters parameters) throws GeneralSecurityException {
        return this.generate(data, parameters, false);
    }

    @Override
    public byte[] generate(byte[] data, CMSSignedDataGeneratorParameters parameters, boolean embedData) throws GeneralSecurityException {
        Collection<CertifyingSigner> signers;
        org.bouncycastle.cms.CMSSignedDataGenerator generator = new org.bouncycastle.cms.CMSSignedDataGenerator();
        Collection<CMSSignerInfo> signersInfo = parameters.getSignatures();
        if (!signersInfo.isEmpty()) {
            signers = new ArrayList<CertifyingSigner>(parameters.getSignatures().size());
            for (CMSSignerInfo signerInfo : parameters.getSignatures()) {
                if (!(signerInfo instanceof BcCMSSignerInfo)) {
                    throw new GeneralSecurityException("Incompatible pre-calculated signature for this signed data generator");
                }
                signers.add((CertifyingSigner)((BcCMSSignerInfo)signerInfo).getSignerInfo());
            }
            generator.addSigners(new SignerInformationStore(signers));
        }
        try {
            signers = parameters.getSigners();
            for (CertifyingSigner signer : signers) {
                if (signer.getAlgorithmIdentifier() == null) {
                    throw new GeneralSecurityException("Incompatible signer for this signed data generator for subject " + signer.getCertifier().getSubject().getName());
                }
                generator.addSignerInfoGenerator(new SignerInfoGeneratorBuilder((DigestCalculatorProvider)this.digestProvider).build((ContentSigner)signer, BcUtils.getX509CertificateHolder(signer.getCertifier())));
            }
            for (CertifiedPublicKey certifiedPublicKey : parameters.getCertificates()) {
                generator.addCertificate(BcUtils.getX509CertificateHolder(certifiedPublicKey));
            }
            return generator.generate((CMSTypedData)new CMSProcessableByteArray(data), embedData).getEncoded();
        }
        catch (CMSException e) {
            throw new GeneralSecurityException("Unable to generate CMS signature", e);
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException("Unable to prepare signers", e);
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Unable to encode signed data", e);
        }
    }
}

