/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params;

import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;

public class CertifiedKeyPair {
    private final PrivateKeyParameters privateKey;
    private final CertifiedPublicKey certificate;

    public CertifiedKeyPair(PrivateKeyParameters privateKey, CertifiedPublicKey certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    public CertifiedPublicKey getCertificate() {
        return this.certificate;
    }

    public PublicKeyParameters getPublicKey() {
        return this.certificate.getPublicKeyParameters();
    }

    public PrivateKeyParameters getPrivateKey() {
        return this.privateKey;
    }

    public AsymmetricKeyPair getKeyPair() {
        return new AsymmetricKeyPair(this.getPrivateKey(), this.getPublicKey());
    }
}

