/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.xwiki.crypto.cipher.Cipher;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;

public abstract class AbstractPBCipher
implements PasswordBasedCipher {
    private KeyDerivationFunction kdf;
    private SymmetricCipherParameters parameters;
    private Cipher cipher;

    public AbstractPBCipher(Cipher cipher, KeyDerivationFunction kdf, SymmetricCipherParameters parameters) {
        this.cipher = cipher;
        this.kdf = kdf;
        this.parameters = parameters;
    }

    @Override
    public KeyDerivationFunction getKeyDerivationFunction() {
        return this.kdf;
    }

    @Override
    public SymmetricCipherParameters getParameters() {
        return this.parameters;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public int getInputBlockSize() {
        return this.cipher.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.cipher.getOutputBlockSize();
    }

    public FilterInputStream getInputStream(InputStream is) {
        return this.cipher.getInputStream(is);
    }

    public FilterOutputStream getOutputStream(OutputStream os) {
        return this.cipher.getOutputStream(os);
    }

    public boolean isForEncryption() {
        return this.cipher.isForEncryption();
    }

    public byte[] update(byte[] input) {
        return this.cipher.update(input);
    }

    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    public byte[] doFinal() throws GeneralSecurityException {
        return this.cipher.doFinal();
    }

    public byte[] doFinal(byte[] input) throws GeneralSecurityException {
        return this.cipher.doFinal(input);
    }

    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }
}

