/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.RC5KeyParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBES2Cipher;
import org.xwiki.crypto.password.internal.pbe.RC5CBCParameter;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBES2CipherFactory;

public abstract class AbstractBcPBES2Rc5CipherFactory
extends AbstractBcPBES2CipherFactory {
    private static final ASN1ObjectIdentifier ALG_ID = PKCSObjectIdentifiers.encryptionAlgorithm.branch("9");

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunction kdf) {
        KeyWithIVParameters params = null;
        if (password instanceof KeyWithIVParameters) {
            KeyParameter passkey = ((KeyWithIVParameters)password).getKeyParameter();
            if (passkey instanceof RC5KeyParameters) {
                params = new KeyWithIVParameters((KeyParameter)new RC5KeyParameters(kdf.derive(passkey.getKey()).getKey(), ((RC5KeyParameters)passkey).getRounds()), ((KeyWithIVParameters)password).getIV());
            }
        } else if (password instanceof RC5KeyParameters) {
            params = kdf.derive(((KeyParameter)password).getKey(), this.getIVSize());
            params = new KeyWithIVParameters((KeyParameter)new RC5KeyParameters(params.getKey(), ((RC5KeyParameters)password).getRounds()), params.getIV());
        }
        if (params == null) {
            throw new IllegalArgumentException("Invalid cipher parameters for RC5-32 password based cipher: " + password.getClass().getName());
        }
        return this.getPasswordBasedCipher(forEncryption, kdf, (SymmetricCipherParameters)params);
    }

    @Override
    protected PasswordBasedCipher getPasswordBasedCipher(boolean forEncryption, KeyDerivationFunction kdf, SymmetricCipherParameters params) {
        return new AbstractBcPBES2Cipher(this.getCipherFactory().getInstance(forEncryption, (CipherParameters)params), kdf, params){

            @Override
            protected EncryptionScheme getScheme(SymmetricCipherParameters parameters) {
                return new EncryptionScheme(ALG_ID, (ASN1Encodable)new RC5CBCParameter(((RC5KeyParameters)((KeyWithIVParameters)parameters).getKeyParameter()).getRounds(), this.getOutputBlockSize(), ((KeyWithIVParameters)parameters).getIV()));
            }
        };
    }

    @Override
    protected PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, KeyDerivationFunc kdfParams, EncryptionScheme scheme) {
        KeyDerivationFunction kdf = this.getKeyDerivationFunction(kdfParams);
        RC5CBCParameter rc5Params = RC5CBCParameter.getInstance(scheme.getParameters());
        return this.getPasswordBasedCipher(forEncryption, kdf, this.getRC5CipherParameters(password, rc5Params, kdf));
    }

    private SymmetricCipherParameters getRC5CipherParameters(byte[] password, RC5CBCParameter rc5Params, KeyDerivationFunction df) {
        RC5KeyParameters keyParam = new RC5KeyParameters(df.derive(password).getKey(), rc5Params.getRounds().intValue());
        if (rc5Params.getIV() != null) {
            return new KeyWithIVParameters((KeyParameter)keyParam, rc5Params.getIV());
        }
        return keyParam;
    }
}

