/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.KeyDerivationFunctionFactory;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.internal.kdf.PBES2Parameters;
import org.xwiki.crypto.password.internal.kdf.factory.AbstractBcKDFFactory;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBCipherFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

public abstract class AbstractBcPBES2CipherFactory
extends AbstractBcPBCipherFactory {
    private static final RuntimeException UNSUPPORTED = new UnsupportedOperationException("Sorry, no concrete implementation to create an instance.");

    private KeyDerivationFunctionFactory safeGetKDFFactory() {
        try {
            return this.getKDFFactory();
        }
        catch (UnsupportedOperationException e) {
            throw UNSUPPORTED;
        }
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, ASN1Encodable parameters) {
        AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance((Object)parameters);
        if (!alg.getAlgorithm().equals((Object)PKCSObjectIdentifiers.id_PBES2)) {
            throw new IllegalArgumentException("Illegal algorithm identifier for PBES2: " + alg.getAlgorithm().getId());
        }
        PBES2Parameters params = PBES2Parameters.getInstance(alg.getParameters());
        return this.getInstance(forEncryption, password, params.getKeyDerivationFunc(), params.getEncryptionScheme());
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunctionParameters parameters) {
        KeyDerivationFunction kdf = this.safeGetKDFFactory().getInstance(parameters);
        if (kdf.getKeySize() < 0 || !this.isSupportedKeySize(kdf.getKeySize())) {
            kdf.overrideKeySize(this.getKeySize());
        }
        return this.getInstance(forEncryption, password, kdf);
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunction kdf) {
        KeyWithIVParameters params;
        if (password instanceof KeyWithIVParameters) {
            params = new KeyWithIVParameters(kdf.derive(((KeyWithIVParameters)password).getKey()), ((KeyWithIVParameters)password).getIV());
        } else if (password instanceof KeyParameter) {
            params = kdf.derive(((KeyParameter)password).getKey(), this.getIVSize());
        } else {
            throw new IllegalArgumentException("Invalid cipher parameters for this password based cipher: " + password.getClass().getName());
        }
        return this.getPasswordBasedCipher(forEncryption, kdf, (SymmetricCipherParameters)params);
    }

    protected PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, KeyDerivationFunc kdfParams, EncryptionScheme scheme) {
        KeyDerivationFunction kdf = this.getKeyDerivationFunction(kdfParams);
        if (kdf.getKeySize() < 0 || !this.isSupportedKeySize(kdf.getKeySize())) {
            kdf.overrideKeySize(this.getKeySize());
        }
        return this.getPasswordBasedCipher(forEncryption, kdf, (SymmetricCipherParameters)new KeyWithIVParameters(kdf.derive(password).getKey(), ((ASN1OctetString)scheme.getParameters()).getOctets()));
    }

    protected PasswordBasedCipher getPasswordBasedCipher(boolean forEncryption, KeyDerivationFunction kdf, SymmetricCipherParameters params) {
        throw UNSUPPORTED;
    }

    protected KeyDerivationFunction getKeyDerivationFunction(KeyDerivationFunc func) {
        KeyDerivationFunctionFactory kdfFactory = this.safeGetKDFFactory();
        if (kdfFactory instanceof AbstractBcKDFFactory) {
            return ((AbstractBcKDFFactory)kdfFactory).getInstance((ASN1Encodable)func);
        }
        try {
            return kdfFactory.getInstance(func.toASN1Primitive().getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception during parameter encoding");
        }
    }
}

