/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.params;

import java.security.SecureRandom;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

public class PBKDF2Parameters
extends KeyDerivationFunctionParameters {
    private static final int SALT_DEFAULT_SIZE = 16;
    private static final int DEFAULT_MIN_ITER = 1000;
    private static final int DEFAULT_ITER_RANGE = 2000;
    private static final SecureRandom PRND = new SecureRandom();
    private final byte[] salt;
    private final int iterationCount;
    private final String prf;

    public PBKDF2Parameters() {
        this(-1);
    }

    public PBKDF2Parameters(SecureRandom random) {
        this(-1, random);
    }

    public PBKDF2Parameters(String prf) {
        this(-1, PBKDF2Parameters.getRandomIterationCount(PRND), PBKDF2Parameters.getRandomSalt(PRND), prf);
    }

    public PBKDF2Parameters(String prf, SecureRandom random) {
        this(-1, PBKDF2Parameters.getRandomIterationCount(random), PBKDF2Parameters.getRandomSalt(random), prf);
    }

    public PBKDF2Parameters(int keySize) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(PRND), PBKDF2Parameters.getRandomSalt(PRND), null);
    }

    public PBKDF2Parameters(int keySize, SecureRandom random) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(random), PBKDF2Parameters.getRandomSalt(random), null);
    }

    public PBKDF2Parameters(int keySize, String prf) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(PRND), PBKDF2Parameters.getRandomSalt(PRND), null);
    }

    public PBKDF2Parameters(int keySize, String prf, SecureRandom random) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(random), PBKDF2Parameters.getRandomSalt(random), null);
    }

    public PBKDF2Parameters(int keySize, int iterationCount) {
        this(keySize, iterationCount, PBKDF2Parameters.getRandomSalt(PRND), null);
    }

    public PBKDF2Parameters(int keySize, int iterationCount, SecureRandom random) {
        this(keySize, iterationCount, PBKDF2Parameters.getRandomSalt(random), null);
    }

    public PBKDF2Parameters(int keySize, int iterationCount, String prf) {
        this(keySize, iterationCount, PBKDF2Parameters.getRandomSalt(PRND), prf);
    }

    public PBKDF2Parameters(int keySize, int iterationCount, String prf, SecureRandom random) {
        this(keySize, iterationCount, PBKDF2Parameters.getRandomSalt(random), prf);
    }

    public PBKDF2Parameters(int keySize, byte[] salt) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(PRND), salt, null);
    }

    public PBKDF2Parameters(int keySize, byte[] salt, SecureRandom random) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(random), salt, null);
    }

    public PBKDF2Parameters(int keySize, byte[] salt, String prf) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(PRND), salt, prf);
    }

    public PBKDF2Parameters(int keySize, byte[] salt, String prf, SecureRandom random) {
        this(keySize, PBKDF2Parameters.getRandomIterationCount(random), salt, prf);
    }

    public PBKDF2Parameters(int keySize, int iterationCount, byte[] salt) {
        this(keySize, iterationCount, salt, null);
    }

    public PBKDF2Parameters(int keySize, int iterationCount, byte[] salt, String prf) {
        super(keySize);
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.prf = prf;
    }

    private static int getRandomIterationCount(SecureRandom random) {
        return random.nextInt(2000) + 1000;
    }

    private static byte[] getRandomSalt(SecureRandom random) {
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return salt;
    }

    @Override
    public String getAlgorithmName() {
        return "PKCS5S2";
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getPseudoRandomFuntionHint() {
        return this.prf;
    }
}

