/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf.factory;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.internal.digest.factory.AbstractBcDigestFactory;
import org.xwiki.crypto.internal.digest.factory.BcDigestFactory;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.internal.kdf.AbstractBcPBKDF2;
import org.xwiki.crypto.password.internal.kdf.PBKDF2Params;
import org.xwiki.crypto.password.internal.kdf.factory.AbstractBcKDFFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;
import org.xwiki.crypto.password.params.PBKDF2Parameters;

@Component(hints={"PKCS5S2", "1.2.840.113549.1.5.12"})
@Singleton
public class BcPKCS5S2KeyDerivationFunctionFactory
extends AbstractBcKDFFactory {
    private static final AlgorithmIdentifier HMAC_SHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, (ASN1Encodable)DERNull.INSTANCE);
    private static final AlgorithmIdentifier HMAC_SHA224 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA224, (ASN1Encodable)DERNull.INSTANCE);
    private static final AlgorithmIdentifier HMAC_SHA256 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256, (ASN1Encodable)DERNull.INSTANCE);
    private static final AlgorithmIdentifier HMAC_SHA384 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA384, (ASN1Encodable)DERNull.INSTANCE);
    private static final AlgorithmIdentifier HMAC_SHA512 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, (ASN1Encodable)DERNull.INSTANCE);
    @Inject
    private ComponentManager manager;

    @Override
    public KeyDerivationFunction getInstance(KeyDerivationFunctionParameters params) {
        PKCS5S2ParametersGenerator generator;
        if (!(params instanceof PBKDF2Parameters)) {
            throw new IllegalArgumentException("Invalid parameter used for PKCS5S2 function: " + params.getClass().getName());
        }
        PBKDF2Parameters kdfParams = (PBKDF2Parameters)params;
        BcDigestFactory factory = null;
        if (kdfParams.getPseudoRandomFuntionHint() != null) {
            factory = this.getDigestFactory(kdfParams.getPseudoRandomFuntionHint());
            generator = new PKCS5S2ParametersGenerator(factory.getDigestInstance());
        } else {
            generator = new PKCS5S2ParametersGenerator();
        }
        return new AbstractBcPBKDF2((PBEParametersGenerator)generator, (PBKDF2Parameters)params, factory != null ? this.toHmacAlgId(factory.getAlgorithmIdentifier()) : HMAC_SHA1){

            @Override
            public KeyDerivationFunc getKeyDerivationFunction() {
                PBKDF2Parameters parameters = (PBKDF2Parameters)this.getParameters();
                AlgorithmIdentifier algId = this.getPRFAlgorithmIdentifier();
                return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)(this.isKeySizeOverwritten() ? new PBKDF2Params(parameters.getSalt(), parameters.getIterationCount(), algId) : new PBKDF2Params(parameters.getSalt(), parameters.getIterationCount(), parameters.getKeySize(), algId)));
            }
        };
    }

    @Override
    public KeyDerivationFunction getInstance(ASN1Encodable parameters) {
        KeyDerivationFunc kdf = KeyDerivationFunc.getInstance((Object)parameters);
        if (!kdf.getAlgorithm().equals((Object)PKCSObjectIdentifiers.id_PBKDF2)) {
            throw new IllegalArgumentException("Illegal algorithm identifier for PBKDF2: " + kdf.getAlgorithm().getId());
        }
        PBKDF2Params params = PBKDF2Params.getInstance(kdf.getParameters());
        return this.getInstance(new PBKDF2Parameters(params.getKeyLength() != null ? params.getKeyLength().intValue() : -1, params.getIterationCount().intValue(), params.getSalt(), this.toDigestHint(params.getPseudoRandomFunctionIdentifier())));
    }

    private BcDigestFactory getDigestFactory(String hint) {
        try {
            DigestFactory factory = (DigestFactory)this.manager.getInstance(DigestFactory.class, hint);
            if (!(factory instanceof BcDigestFactory)) {
                throw new IllegalArgumentException("Requested digest algorithm is not implemented by a factory compatible with this factory. Factory found: " + factory.getClass().getName());
            }
            return (AbstractBcDigestFactory)factory;
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Digest algorithm not found: " + hint, e);
        }
    }

    private AlgorithmIdentifier toHmacAlgId(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier algId = algorithmIdentifier.getAlgorithm();
        AlgorithmIdentifier hmac = null;
        if (algId.equals((Object)X509ObjectIdentifiers.id_SHA1)) {
            hmac = HMAC_SHA1;
        } else if (algId.equals((Object)NISTObjectIdentifiers.id_sha224)) {
            hmac = HMAC_SHA224;
        } else if (algId.equals((Object)NISTObjectIdentifiers.id_sha256)) {
            hmac = HMAC_SHA256;
        } else if (algId.equals((Object)NISTObjectIdentifiers.id_sha384)) {
            hmac = HMAC_SHA384;
        } else if (algId.equals((Object)NISTObjectIdentifiers.id_sha512)) {
            hmac = HMAC_SHA512;
        }
        if (hmac == null) {
            throw new IllegalArgumentException("HMac algorithm not found for digest: " + algId.getId());
        }
        return hmac;
    }

    private String toDigestHint(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier == null) {
            return null;
        }
        ASN1ObjectIdentifier algId = algorithmIdentifier.getAlgorithm();
        String hint = null;
        if (algId.equals((Object)HMAC_SHA1.getAlgorithm())) {
            hint = X509ObjectIdentifiers.id_SHA1.getId();
        } else if (algId.equals((Object)HMAC_SHA224.getAlgorithm())) {
            hint = NISTObjectIdentifiers.id_sha224.getId();
        } else if (algId.equals((Object)HMAC_SHA256.getAlgorithm())) {
            hint = NISTObjectIdentifiers.id_sha256.getId();
        } else if (algId.equals((Object)HMAC_SHA384.getAlgorithm())) {
            hint = NISTObjectIdentifiers.id_sha384.getId();
        } else if (algId.equals((Object)HMAC_SHA512.getAlgorithm())) {
            hint = NISTObjectIdentifiers.id_sha512.getId();
        }
        if (hint == null) {
            throw new IllegalArgumentException("Digest hint not found for HMac algorithm: " + algId.getId());
        }
        return hint;
    }
}

