/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf;

import java.io.IOException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.password.internal.kdf.AbstractBcKDF;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;
import org.xwiki.crypto.password.params.PBKDF2Parameters;

public abstract class AbstractBcPBKDF2
extends AbstractBcKDF {
    private final PBEParametersGenerator generator;
    private final PBKDF2Parameters parameters;
    private final AlgorithmIdentifier algId;

    public AbstractBcPBKDF2(PBEParametersGenerator generator, PBKDF2Parameters parameters, AlgorithmIdentifier algId) {
        this.generator = generator;
        this.parameters = parameters;
        this.algId = algId;
    }

    @Override
    public KeyDerivationFunctionParameters getParameters() {
        return this.parameters;
    }

    public AlgorithmIdentifier getPRFAlgorithmIdentifier() {
        if (this.parameters.getPseudoRandomFuntionHint() != null) {
            return this.algId;
        }
        return null;
    }

    @Override
    public KeyParameter derive(byte[] password) {
        this.generator.init(password, this.parameters.getSalt(), this.parameters.getIterationCount());
        org.bouncycastle.crypto.params.KeyParameter keyParam = (org.bouncycastle.crypto.params.KeyParameter)this.generator.generateDerivedParameters(this.getKeySize() * 8);
        return new KeyParameter(keyParam.getKey());
    }

    @Override
    public KeyWithIVParameters derive(byte[] password, int ivSize) {
        this.generator.init(password, this.parameters.getSalt(), this.parameters.getIterationCount());
        ParametersWithIV keyParam = (ParametersWithIV)this.generator.generateDerivedParameters(this.getKeySize() * 8, ivSize * 8);
        return new KeyWithIVParameters(((org.bouncycastle.crypto.params.KeyParameter)keyParam.getParameters()).getKey(), keyParam.getIV());
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.getKeyDerivationFunction().getEncoded();
    }
}

