/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password;

import org.bouncycastle.crypto.PBEParametersGenerator;

public final class PasswordToByteConverter {
    private PasswordToByteConverter() {
    }

    public static byte[] convert(String password) {
        return PasswordToByteConverter.convert(password.toCharArray());
    }

    public static byte[] convert(char[] password) {
        return PasswordToByteConverter.convert(password, ToBytesMode.PKCS5_UTF8);
    }

    public static byte[] convert(String password, ToBytesMode mode) {
        return PasswordToByteConverter.convert(password.toCharArray(), mode);
    }

    public static byte[] convert(char[] password, ToBytesMode mode) {
        return switch (mode) {
            case ToBytesMode.PKCS12 -> PBEParametersGenerator.PKCS12PasswordToBytes((char[])password);
            case ToBytesMode.PKCS5 -> PBEParametersGenerator.PKCS5PasswordToBytes((char[])password);
            default -> PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])password);
        };
    }

    public static enum ToBytesMode {
        PKCS5_UTF8,
        PKCS5,
        PKCS12;

    }
}

