/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf.factory;

import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.internal.kdf.BcScryptKDF;
import org.xwiki.crypto.password.internal.kdf.ScryptKDFParams;
import org.xwiki.crypto.password.internal.kdf.factory.AbstractBcKDFFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;
import org.xwiki.crypto.password.params.ScryptParameters;

@Component(hints={"Scrypt", "1.3.6.1.4.1.11591.4.11"})
@Singleton
public class BcScryptKeyDerivationFunctionFactory
extends AbstractBcKDFFactory {
    private static final ASN1ObjectIdentifier ALG_ID = new ASN1ObjectIdentifier("1.3.6.1.4.1.11591.4.11");

    @Override
    public KeyDerivationFunction getInstance(KeyDerivationFunctionParameters params) {
        if (!(params instanceof ScryptParameters)) {
            throw new IllegalArgumentException("Invalid parameter used for Scrypt function: " + params.getClass().getName());
        }
        return new BcScryptKDF((ScryptParameters)params);
    }

    @Override
    public KeyDerivationFunction getInstance(ASN1Encodable parameters) {
        KeyDerivationFunc kdf = KeyDerivationFunc.getInstance((Object)parameters);
        if (!kdf.getAlgorithm().equals((ASN1Primitive)ALG_ID)) {
            throw new IllegalArgumentException("Illegal algorithm identifier for Scrypt: " + kdf.getAlgorithm().getId());
        }
        ScryptKDFParams params = ScryptKDFParams.getInstance(kdf.getParameters());
        return this.getInstance(new ScryptParameters(params.getKeyLength() != null ? params.getKeyLength().intValue() : -1, params.getCostParameter().intValue(), params.getParallelizationParameter().intValue(), params.getBlockSize().intValue(), params.getSalt()));
    }
}

