/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class RC5CBCParameter
extends ASN1Object {
    private ASN1Integer version;
    private ASN1Integer rounds;
    private ASN1Integer blockSizeInBits;
    private ASN1OctetString iv;

    public RC5CBCParameter(int rounds, int blockSizeInBits) {
        this(16, rounds, blockSizeInBits, null);
    }

    public RC5CBCParameter(int rounds, int blockSizeInBits, byte[] iv) {
        this(16, rounds, blockSizeInBits, iv);
    }

    public RC5CBCParameter(int parameterVersion, int rounds, int blockSizeInBits, byte[] iv) {
        this.version = new ASN1Integer((long)parameterVersion);
        this.rounds = new ASN1Integer((long)rounds);
        this.blockSizeInBits = new ASN1Integer((long)blockSizeInBits);
        this.iv = iv != null ? new DEROctetString(iv) : null;
    }

    private RC5CBCParameter(ASN1Sequence seq) {
        this.version = (ASN1Integer)seq.getObjectAt(0);
        this.rounds = (ASN1Integer)seq.getObjectAt(1);
        this.blockSizeInBits = (ASN1Integer)seq.getObjectAt(2);
        if (seq.size() > 3) {
            this.iv = (ASN1OctetString)seq.getObjectAt(3);
        }
    }

    public static RC5CBCParameter getInstance(Object obj) {
        if (obj instanceof RC5CBCParameter) {
            return (RC5CBCParameter)((Object)obj);
        }
        if (obj != null) {
            return new RC5CBCParameter(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public BigInteger getRC5ParameterVersion() {
        return this.version.getValue();
    }

    public BigInteger getRounds() {
        return this.rounds.getValue();
    }

    public BigInteger getBlockSizeInBits() {
        return this.blockSizeInBits.getValue();
    }

    public byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.getOctets();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.rounds);
        v.add((ASN1Encodable)this.blockSizeInBits);
        if (this.iv != null) {
            v.add((ASN1Encodable)this.iv);
        }
        return new DERSequence(v);
    }
}

