/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.params;

import java.security.SecureRandom;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

public class ScryptParameters
extends KeyDerivationFunctionParameters {
    private static final int SALT_DEFAULT_SIZE = 16;
    private static final int COST_DEFAULT = 1024;
    private static final int PARALLELIZATION_DEFAULT = 1;
    private static final int BLOCK_DEFAULT_SIZE = 8;
    private static final SecureRandom PRND = new SecureRandom();
    private final byte[] salt;
    private final int costParameter;
    private final int blockSize;
    private final int parallelizationParameter;

    public ScryptParameters() {
        this(-1, 1024, 1, 8, ScryptParameters.getRandomSalt());
    }

    public ScryptParameters(int keySize) {
        this(keySize, 1024, 1, 8, ScryptParameters.getRandomSalt());
    }

    public ScryptParameters(int keySize, byte[] salt) {
        this(keySize, 1024, 1, 8, salt);
    }

    public ScryptParameters(int keySize, int costParameter, int parallelizationParameter) {
        this(keySize, costParameter, parallelizationParameter, 8, ScryptParameters.getRandomSalt());
    }

    public ScryptParameters(int keySize, int costParameter, int parallelizationParameter, byte[] salt) {
        this(keySize, costParameter, parallelizationParameter, 8, salt);
    }

    public ScryptParameters(int keySize, int costParameter, int parallelizationParameter, int blockSize) {
        this(keySize, costParameter, parallelizationParameter, blockSize, ScryptParameters.getRandomSalt());
    }

    public ScryptParameters(int keySize, int costParameter, int parallelizationParameter, int blockSize, byte[] salt) {
        super(keySize);
        this.costParameter = costParameter;
        this.blockSize = blockSize;
        this.parallelizationParameter = parallelizationParameter;
        this.salt = salt;
    }

    private static byte[] getRandomSalt() {
        byte[] salt = new byte[16];
        PRND.nextBytes(salt);
        return salt;
    }

    @Override
    public String getAlgorithmName() {
        return "Scrypt";
    }

    public int getCostParameter() {
        return this.costParameter;
    }

    public int getParallelizationParameter() {
        return this.parallelizationParameter;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

