/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.kdf;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.xwiki.crypto.password.internal.kdf.PBKDF2Params;

public class PBES2Parameters
extends ASN1Object
implements PKCSObjectIdentifiers {
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Parameters(KeyDerivationFunc keyDevFunc, EncryptionScheme encScheme) {
        this.func = keyDevFunc;
        this.scheme = encScheme;
    }

    private PBES2Parameters(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        ASN1Sequence funcSeq = ASN1Sequence.getInstance((Object)((ASN1Encodable)e.nextElement()).toASN1Primitive());
        this.func = funcSeq.getObjectAt(0).equals(id_PBKDF2) ? new KeyDerivationFunc(id_PBKDF2, (ASN1Encodable)PBKDF2Params.getInstance(funcSeq.getObjectAt(1))) : KeyDerivationFunc.getInstance((Object)funcSeq);
        this.scheme = EncryptionScheme.getInstance(e.nextElement());
    }

    public static PBES2Parameters getInstance(Object obj) {
        if (obj instanceof PBES2Parameters) {
            return (PBES2Parameters)((Object)obj);
        }
        if (obj instanceof org.bouncycastle.asn1.pkcs.PBES2Parameters) {
            return new PBES2Parameters(((org.bouncycastle.asn1.pkcs.PBES2Parameters)obj).getKeyDerivationFunc(), ((org.bouncycastle.asn1.pkcs.PBES2Parameters)obj).getEncryptionScheme());
        }
        if (obj != null) {
            return new PBES2Parameters(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.func);
        v.add((ASN1Encodable)this.scheme);
        return new DERSequence(v);
    }
}

