/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.xwiki.crypto.cipher.internal.symmetric.BcSymmetricCipher;

public class BcPaddedSymmetricCipher
extends BcSymmetricCipher {
    private static final String SEPARATOR = "/";
    private static final String PADDING = "Padding";
    private static final String PKCS5_PADDING = "PKCS5Padding";
    private static final String PKCS7_PADDING = "PKCS7Padding";
    private String paddingName;

    public BcPaddedSymmetricCipher(BlockCipher cipher, boolean forEncryption, CipherParameters parameters) {
        super((BufferedBlockCipher)new PaddedBufferedBlockCipher(cipher), forEncryption, parameters);
        this.paddingName = this.getOutputBlockSize() <= 8 ? PKCS5_PADDING : PKCS7_PADDING;
    }

    public BcPaddedSymmetricCipher(BlockCipher cipher, boolean forEncryption, CipherParameters parameters, BlockCipherPadding padding) {
        super((BufferedBlockCipher)new PaddedBufferedBlockCipher(cipher, padding), forEncryption, parameters);
        this.paddingName = padding.getPaddingName() + PADDING;
        if (PKCS7_PADDING.equals(this.paddingName) && this.getOutputBlockSize() <= 8) {
            this.paddingName = PKCS5_PADDING;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + SEPARATOR + this.paddingName;
    }
}

