/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Singleton;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.params.DESedeParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcCbcPaddedCipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;

@Component(hints={"DESede/CBC/PKCS5Padding", "DESede/CBC/PKCS7Padding", "1.2.840.113549.3.7"})
@Singleton
public class BcDesEdeCbcPaddedCipherFactory
extends AbstractBcCbcPaddedCipherFactory {
    private static final int[] KEY_SIZES = BcDesEdeCbcPaddedCipherFactory.newKeySizeArray(16, 24, 8);

    @Override
    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        return new DESedeParameters(parameter.getKey());
    }

    @Override
    protected BlockCipher getEngineInstance() {
        return new DESedeEngine();
    }

    @Override
    public int[] getSupportedKeySizes() {
        return KEY_SIZES;
    }
}

