/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextInitializer;
import org.xwiki.context.ExecutionContextManager;

@Component
@Singleton
public class DefaultExecutionContextManager
implements ExecutionContextManager {
    private static final String XWIKICONTEXT_KEY = "xwikicontext";
    private static final String VELOCITY_KEY = "velocityContext";
    @Inject
    private Execution execution;
    @Inject
    private List<ExecutionContextInitializer> initializers = new ArrayList<ExecutionContextInitializer>();

    public DefaultExecutionContextManager() {
    }

    public DefaultExecutionContextManager(Execution execution) {
        this.execution = execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionContext clone(ExecutionContext context) throws ExecutionContextException {
        ExecutionContext currentContext = this.execution.getContext();
        ExecutionContext clonedContext = new ExecutionContext();
        try {
            this.execution.pushContext(clonedContext);
        }
        catch (RuntimeException e) {
            throw new ExecutionContextException("Failed to push cloned execution context.", e);
        }
        try {
            this.runInitializers(clonedContext);
        }
        finally {
            this.execution.popContext();
        }
        return clonedContext;
    }

    @Override
    public void initialize(ExecutionContext context) throws ExecutionContextException {
        try {
            this.execution.setContext(context);
        }
        catch (RuntimeException e) {
            throw new ExecutionContextException("Failed to set the execution context.", e);
        }
        this.runInitializers(context);
    }

    private void runInitializers(ExecutionContext context) throws ExecutionContextException {
        for (ExecutionContextInitializer initializer : this.initializers) {
            initializer.initialize(context);
        }
    }

    public void addExecutionContextInitializer(ExecutionContextInitializer initializer) {
        this.initializers.add(initializer);
    }
}

