/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.VoidConfigurationSource;

@Component
@Named(value="configurationSource")
@Singleton
public class ConfigurationSourceProvider
implements Provider<ConfigurationSource> {
    @Inject
    private ComponentManager componentManager;

    public ConfigurationSource get() {
        ConfigurationSource configurationSource;
        try {
            configurationSource = (ConfigurationSource)this.componentManager.lookup(ConfigurationSource.class);
        }
        catch (ComponentLookupException e) {
            try {
                configurationSource = (ConfigurationSource)this.componentManager.lookup(ConfigurationSource.class, "memory");
            }
            catch (ComponentLookupException e1) {
                configurationSource = this.getVoidConfigurationSource();
            }
        }
        return configurationSource;
    }

    private ConfigurationSource getVoidConfigurationSource() {
        ConfigurationSource configurationSource;
        try {
            configurationSource = (ConfigurationSource)this.componentManager.lookup(ConfigurationSource.class, "void");
        }
        catch (ComponentLookupException e) {
            configurationSource = new VoidConfigurationSource();
        }
        return configurationSource;
    }
}

