/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.annotation.Role;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;

public abstract class AbstractGenericProvider<T> {
    protected ComponentManager componentManager;
    private RoleHint<T> roleHint;

    AbstractGenericProvider(ComponentManager componentManager, RoleHint<T> roleHint) {
        this.componentManager = componentManager;
        this.roleHint = roleHint;
    }

    public T get() {
        Object component;
        try {
            Class<T> roleClass = this.roleHint.getRoleClass();
            if (roleClass.isAssignableFrom(jakarta.inject.Provider.class) || roleClass.isAssignableFrom(Provider.class)) {
                try {
                    component = this.componentManager.getInstance(this.roleHint.getRoleType(), this.roleHint.getHint());
                }
                catch (ComponentLookupException e) {
                    component = this.newProvider(this.componentManager, new RoleHint(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType()), this.roleHint.getHint()));
                }
            } else {
                component = roleClass.isAssignableFrom(List.class) ? this.componentManager.getInstanceList(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType())) : (roleClass.isAssignableFrom(Map.class) ? this.componentManager.getInstanceMap(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType())) : (ReflectionUtils.getDirectAnnotation(ComponentRole.class, roleClass) != null && ReflectionUtils.getDirectAnnotation(Role.class, roleClass) == null ? this.getInstance(roleClass, this.roleHint.getHint()) : this.getInstance(this.roleHint.getRoleType(), this.roleHint.getHint())));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get [" + String.valueOf(this.roleHint) + "]", e);
        }
        return (T)component;
    }

    protected abstract AbstractGenericProvider<T> newProvider(ComponentManager var1, RoleHint<T> var2);

    protected T getInstance(Type type, String hint) throws ComponentLookupException {
        return (T)this.componentManager.getInstance(type, hint);
    }
}

