/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.lang.reflect.Field;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.AbstractComponentDependencyFactory;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.annotation.Role;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.util.ReflectionUtils;

public class DefaultComponentDependencyFactory
extends AbstractComponentDependencyFactory {
    @Override
    public ComponentDependency createComponentDependency(Field field) {
        DefaultComponentDependency dependency;
        Inject inject = field.getAnnotation(Inject.class);
        if (inject != null) {
            dependency = new DefaultComponentDependency();
            Class<?> fieldClass = field.getType();
            if (ReflectionUtils.getDirectAnnotation(ComponentRole.class, fieldClass) != null && ReflectionUtils.getDirectAnnotation(Role.class, fieldClass) == null) {
                dependency.setRoleType(fieldClass);
            } else {
                dependency.setRoleType(field.getGenericType());
            }
            dependency.setName(field.getName());
            Named named = field.getAnnotation(Named.class);
            if (named != null) {
                dependency.setRoleHint(named.value());
            }
        } else {
            dependency = null;
        }
        return dependency;
    }
}

