/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentRole;

public class DefaultComponentDescriptor<T>
extends DefaultComponentRole<T>
implements ComponentDescriptor<T> {
    private Class<? extends T> implementation;
    private ComponentInstantiationStrategy instantiationStrategy = ComponentInstantiationStrategy.SINGLETON;
    private List<ComponentDependency<?>> componentDependencies = new ArrayList();

    public DefaultComponentDescriptor() {
    }

    public DefaultComponentDescriptor(ComponentDescriptor<T> descriptor) {
        super(descriptor);
        this.setImplementation(descriptor.getImplementation());
        this.setInstantiationStrategy(descriptor.getInstantiationStrategy());
        for (ComponentDependency<?> dependency : descriptor.getComponentDependencies()) {
            this.addComponentDependency(new DefaultComponentDependency(dependency));
        }
    }

    public void setImplementation(Class<? extends T> implementation) {
        this.implementation = implementation;
    }

    @Override
    public Class<? extends T> getImplementation() {
        return this.implementation;
    }

    public void setInstantiationStrategy(ComponentInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    @Override
    public ComponentInstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    @Override
    public Collection<ComponentDependency<?>> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void addComponentDependency(ComponentDependency<?> componentDependency) {
        this.componentDependencies.add(componentDependency);
    }

    public <TT> void addComponentDependency(Class<TT> role, String roleHint) {
        DefaultComponentDependency<TT> componentDependency = new DefaultComponentDependency<TT>();
        componentDependency.setRole(role);
        componentDependency.setRoleHint(roleHint);
        this.componentDependencies.add(componentDependency);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" implementation = [").append(this.getImplementation() == null ? null : this.getImplementation().getName()).append("]");
        buffer.append(" instantiation = [").append((Object)this.getInstantiationStrategy()).append("]");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        DefaultComponentDescriptor cd;
        boolean result = this == object ? true : (object == null || object.getClass() != this.getClass() ? false : super.equals(cd = (DefaultComponentDescriptor)object) && (this.getImplementation() == cd.getImplementation() || this.getImplementation() != null && this.getImplementation().equals(cd.getImplementation())) && this.getInstantiationStrategy() == cd.getInstantiationStrategy() && ((Object)this.getComponentDependencies()).equals(cd.getComponentDependencies()));
        return result;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + (null == this.getImplementation() ? 0 : this.getImplementation().hashCode());
        hash = 31 * hash + this.getInstantiationStrategy().hashCode();
        hash = 31 * hash + ((Object)this.getComponentDependencies()).hashCode();
        return hash;
    }
}

