/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.collection;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class SoftCache<K, V> {
    private Map<K, V> map = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.SOFT, AbstractReferenceMap.ReferenceStrength.SOFT);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key, V defaultValue) {
        V sharedValue = this.get(key);
        if (sharedValue == null) {
            sharedValue = defaultValue;
            this.put(key, defaultValue);
        }
        return sharedValue;
    }

    public void put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

