/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.test;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.test.AbstractTestCache;
import org.xwiki.cache.test.TestCacheEntryListener;

public abstract class AbstractGenericTestCache
extends AbstractTestCache {
    protected AbstractGenericTestCache(String roleHint) {
        super(roleHint);
    }

    @Test
    void getFactory() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        CacheFactory factory2 = this.getCacheFactory();
        Assertions.assertSame((Object)factory, (Object)factory2);
    }

    @Test
    void createAndDestroyCacheSimple() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        Assertions.assertNotNull((Object)cache);
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        Assertions.assertEquals((Object)2, (Object)cache.get("key2"));
        cache.dispose();
    }

    @Test
    void remove() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        cache.remove("key");
        Assertions.assertNull((Object)cache.get("key"));
        Assertions.assertEquals((Object)2, (Object)cache.get("key2"));
    }

    @Test
    void removeAll() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        cache.removeAll();
        Assertions.assertNull((Object)cache.get("key"));
        Assertions.assertNull((Object)cache.get("key2"));
    }

    @Test
    void events() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        TestCacheEntryListener eventListener = new TestCacheEntryListener();
        cache.addCacheEntryListener((CacheEntryListener)eventListener);
        cache.remove("key");
        Assertions.assertNull(eventListener.getRemovedEvent());
        cache.set("key", (Object)"value");
        Assertions.assertNotNull(eventListener.getAddedEvent());
        Assertions.assertSame((Object)cache, (Object)eventListener.getAddedEvent().getCache());
        Assertions.assertEquals((Object)"key", (Object)eventListener.getAddedEvent().getEntry().getKey());
        Assertions.assertEquals((Object)"value", (Object)eventListener.getAddedEvent().getEntry().getValue());
        cache.set("key", (Object)2);
        Assertions.assertNotNull(eventListener.getModifiedEvent());
        Assertions.assertSame((Object)cache, (Object)eventListener.getModifiedEvent().getCache());
        Assertions.assertEquals((Object)"key", (Object)eventListener.getModifiedEvent().getEntry().getKey());
        Assertions.assertEquals((Object)2, (Object)eventListener.getModifiedEvent().getEntry().getValue());
        cache.remove("key");
        cache.get("key");
        Assertions.assertNotNull(eventListener.getRemovedEvent());
        Assertions.assertSame((Object)cache, (Object)eventListener.getRemovedEvent().getCache());
        Assertions.assertEquals((Object)"key", (Object)eventListener.getRemovedEvent().getEntry().getKey());
        Assertions.assertEquals((Object)2, (Object)eventListener.getRemovedEvent().getEntry().getValue());
    }

    @Test
    void severalCaches() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        Cache cache2 = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        Assertions.assertNull((Object)cache2.get("key"));
    }

    @Test
    void recreateCache() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration configuration = new CacheConfiguration();
        configuration.setConfigurationId("test");
        Cache cache = factory.newCache(configuration);
        TestCacheEntryListener eventListener = new TestCacheEntryListener();
        cache.addCacheEntryListener((CacheEntryListener)eventListener);
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.dispose();
        Assertions.assertNotNull(eventListener.getRemovedEvent());
        cache = factory.newCache(configuration);
        Assertions.assertNull((Object)cache.get("key"));
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
    }
}

