/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import org.apache.commons.lang3.StringUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;
import org.xwiki.environment.Environment;

public class InfinispanConfigurationLoader
extends AbstractCacheConfigurationLoader {
    public static final String CONFX_EXPIRATION_WAKEUPINTERVAL = "infinispan.expiration.wakeupinterval";
    private static final String DEFAULT_SINGLEFILESTORE_LOCATION = "Infinispan-SingleFileStore";

    public InfinispanConfigurationLoader(CacheConfiguration configuration, Environment environment) {
        super(configuration, environment, null);
    }

    private void customizeEviction(ConfigurationBuilder builder) {
        EntryEvictionConfiguration eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction");
        if (eec != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
            this.customizeEvictionMaxEntries(builder, eec);
            this.customizeExpirationWakeUpInterval(builder, eec);
            this.customizeExpirationMaxIdle(builder, eec);
            this.customizeExpirationLifespan(builder, eec);
        }
    }

    private void customizeEvictionMaxEntries(ConfigurationBuilder builder, EntryEvictionConfiguration eec) {
        Object maxEntries = eec.get((Object)"maxentries");
        if (maxEntries instanceof Number) {
            builder.memory().evictionStrategy(EvictionStrategy.REMOVE);
            builder.memory().evictionType(EvictionType.COUNT).size(((Number)maxEntries).longValue());
        }
    }

    private void customizeExpirationWakeUpInterval(ConfigurationBuilder builder, EntryEvictionConfiguration eec) {
        if (eec.get((Object)CONFX_EXPIRATION_WAKEUPINTERVAL) instanceof Number) {
            builder.expiration().wakeUpInterval(((Number)eec.get((Object)CONFX_EXPIRATION_WAKEUPINTERVAL)).longValue());
        }
    }

    private void customizeExpirationMaxIdle(ConfigurationBuilder builder, EntryEvictionConfiguration eec) {
        if (eec.getTimeToLive() > 0) {
            builder.expiration().maxIdle((long)eec.getTimeToLive() * 1000L);
        }
    }

    private void customizeExpirationLifespan(ConfigurationBuilder builder, EntryEvictionConfiguration eec) {
        if (eec.containsKey((Object)"lifespan")) {
            long lifespan = (long)((Integer)eec.get((Object)"lifespan")).intValue() * 1000L;
            builder.expiration().lifespan(lifespan);
        }
    }

    private boolean containsIncompleteFileLoader(Configuration configuration) {
        PersistenceConfiguration persistenceConfiguration = configuration.persistence();
        for (StoreConfiguration storeConfiguration : persistenceConfiguration.stores()) {
            SingleFileStoreConfiguration singleFileStoreConfiguration;
            String location;
            if (!(storeConfiguration instanceof SingleFileStoreConfiguration) || !StringUtils.isBlank((CharSequence)(location = (singleFileStoreConfiguration = (SingleFileStoreConfiguration)storeConfiguration).location())) && !location.equals(DEFAULT_SINGLEFILESTORE_LOCATION)) continue;
            return true;
        }
        return false;
    }

    private void completeFilesystem(ConfigurationBuilder builder, Configuration configuration) {
        PersistenceConfigurationBuilder persistence = builder.persistence();
        if (this.containsIncompleteFileLoader(configuration)) {
            for (StoreConfigurationBuilder store : persistence.stores()) {
                if (!(store instanceof SingleFileStoreConfigurationBuilder)) continue;
                SingleFileStoreConfigurationBuilder singleFileStore = (SingleFileStoreConfigurationBuilder)store;
                singleFileStore.location(this.createTempDir());
            }
        }
    }

    public Configuration customize(Configuration defaultConfiguration, Configuration namedConfiguration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (namedConfiguration != null) {
            this.read(builder, namedConfiguration);
        } else {
            if (defaultConfiguration != null) {
                this.read(builder, defaultConfiguration);
            }
            this.customizeEviction(builder);
        }
        return builder.build();
    }

    private void read(ConfigurationBuilder builder, Configuration configuration) {
        builder.read(configuration);
        this.completeFilesystem(builder, configuration);
    }
}

