/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.eviction;

import org.xwiki.cache.eviction.EntryEvictionConfiguration;

public class LRUEvictionConfiguration
extends EntryEvictionConfiguration {
    public static final String MAXENTRIES_ID = "maxentries";
    public static final String LIFESPAN_ID = "lifespan";

    public LRUEvictionConfiguration() {
        this.setAlgorithm(EntryEvictionConfiguration.Algorithm.LRU);
    }

    public LRUEvictionConfiguration(int maxEntries) {
        this();
        this.setMaxEntries(maxEntries);
    }

    public void setMaxEntries(int maxEntries) {
        this.put(MAXENTRIES_ID, maxEntries);
    }

    public int getMaxEntries() {
        Object obj = this.get(MAXENTRIES_ID);
        return obj == null ? 0 : (Integer)this.get(MAXENTRIES_ID);
    }

    public void setMaxIdle(int maxIdle) {
        this.setTimeToLive(maxIdle);
    }

    public int getMaxIdle() {
        return this.getTimeToLive();
    }

    public void setLifespan(int lifespan) {
        this.put(LIFESPAN_ID, lifespan);
    }

    public int getLifespan() {
        Object obj = this.get(LIFESPAN_ID);
        return obj == null ? 0 : (Integer)this.get(LIFESPAN_ID);
    }
}

