/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AbstractAssert;
import org.xmlunit.assertj.CompareAssert;
import org.xmlunit.assertj.MultipleNodeAssert;
import org.xmlunit.assertj.ValidationAssert;
import org.xmlunit.assertj.ValueAssert;
import org.xmlunit.assertj.error.ShouldNotHaveThrown;

public class XmlAssert
extends AbstractAssert<XmlAssert, Object> {
    private DocumentBuilderFactory dbf;
    private XPathFactory xpf;
    private Map<String, String> prefix2Uri;

    private XmlAssert(Object o) {
        super(o, XmlAssert.class);
    }

    public static XmlAssert assertThat(Object o) {
        return new XmlAssert(o);
    }

    public XmlAssert withDocumentBuilderFactory(DocumentBuilderFactory dbf) {
        this.isNotNull();
        this.dbf = dbf;
        return this;
    }

    public XmlAssert withXPathFactory(XPathFactory xpf) {
        this.isNotNull();
        this.xpf = xpf;
        return this;
    }

    public XmlAssert withNamespaceContext(Map<String, String> prefix2Uri) {
        this.isNotNull();
        this.prefix2Uri = prefix2Uri;
        return this;
    }

    public MultipleNodeAssert nodesByXPath(String xPath) {
        this.isNotNull();
        try {
            return MultipleNodeAssert.create(this.actual, this.prefix2Uri, this.dbf, this.xpf, xPath);
        }
        catch (Exception e) {
            this.throwAssertionError(ShouldNotHaveThrown.shouldNotHaveThrown(e));
            return null;
        }
    }

    public MultipleNodeAssert hasXPath(String xPath) {
        return this.nodesByXPath(xPath).exist();
    }

    public void doesNotHaveXPath(String xPath) {
        this.nodesByXPath(xPath).doNotExist();
    }

    public ValueAssert valueByXPath(String xPath) {
        this.isNotNull();
        try {
            return ValueAssert.create(this.actual, this.prefix2Uri, this.dbf, this.xpf, xPath);
        }
        catch (Exception e) {
            this.throwAssertionError(ShouldNotHaveThrown.shouldNotHaveThrown(e));
            return null;
        }
    }

    public CompareAssert and(Object control) {
        this.isNotNull();
        try {
            return CompareAssert.create(this.actual, control, this.prefix2Uri, this.dbf);
        }
        catch (Exception e) {
            this.throwAssertionError(ShouldNotHaveThrown.shouldNotHaveThrown(e));
            return null;
        }
    }

    public XmlAssert isValid() {
        this.isNotNull();
        ValidationAssert.create(this.actual).isValid();
        return this;
    }

    public XmlAssert isInvalid() {
        this.isNotNull();
        ValidationAssert.create(this.actual).isInvalid();
        return this;
    }

    public XmlAssert isValidAgainst(Schema schema) {
        this.isNotNull();
        ValidationAssert.create(this.actual, schema).isValid();
        return this;
    }

    public XmlAssert isNotValidAgainst(Schema schema) {
        this.isNotNull();
        ValidationAssert.create(this.actual, schema).isInvalid();
        return this;
    }

    public XmlAssert isValidAgainst(Object ... schemaSources) {
        this.isNotNull();
        ValidationAssert.create(this.actual, schemaSources).isValid();
        return this;
    }

    public XmlAssert isNotValidAgainst(Object ... schemaSources) {
        this.isNotNull();
        ValidationAssert.create(this.actual, schemaSources).isInvalid();
        return this;
    }
}

