/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.ErrorMessageFactory;
import org.w3c.dom.Node;
import org.xmlunit.assertj.XmlAssert;
import org.xmlunit.assertj.error.ShouldBeConvertible;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class ValueAssert
extends AbstractCharSequenceAssert<ValueAssert, String> {
    private ValueAssert(String value) {
        super((CharSequence)value, ValueAssert.class);
    }

    static ValueAssert create(Object xmlSource, Map<String, String> prefix2Uri, DocumentBuilderFactory dbf, XPathFactory xpf, String xPath) {
        JAXPXPathEngine engine;
        Assertions.assertThat((String)xPath).isNotBlank();
        JAXPXPathEngine jAXPXPathEngine = engine = xpf == null ? new JAXPXPathEngine() : new JAXPXPathEngine(xpf);
        if (prefix2Uri != null) {
            engine.setNamespaceContext(prefix2Uri);
        }
        Source s = Input.from((Object)xmlSource).build();
        Node root = dbf != null ? Convert.toNode((Source)s, (DocumentBuilderFactory)dbf) : Convert.toNode((Source)s);
        String value = engine.evaluate(xPath, root);
        return (ValueAssert)new ValueAssert(value).describedAs("XPath \"%s\" evaluated to value", new Object[]{xPath});
    }

    public AbstractIntegerAssert<?> asInt() {
        this.isNotNull();
        int value = 0;
        try {
            value = Integer.parseInt((String)this.actual);
        }
        catch (NumberFormatException e) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeConvertible.shouldBeConvertible((String)this.actual, "int"));
        }
        return Assertions.assertThat((int)value);
    }

    public AbstractDoubleAssert<?> asDouble() {
        this.isNotNull();
        double value = 0.0;
        try {
            value = Double.parseDouble((String)this.actual);
        }
        catch (NumberFormatException e) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeConvertible.shouldBeConvertible((String)this.actual, "double"));
        }
        return Assertions.assertThat((double)value);
    }

    public AbstractBooleanAssert<?> asBoolean() {
        this.isNotNull();
        boolean value = false;
        switch (((String)this.actual).toLowerCase()) {
            case "1": 
            case "true": {
                value = true;
                break;
            }
            case "0": 
            case "false": {
                value = false;
                break;
            }
            default: {
                this.throwAssertionError((ErrorMessageFactory)ShouldBeConvertible.shouldBeConvertible((String)this.actual, "boolean"));
            }
        }
        return Assertions.assertThat((boolean)value);
    }

    public XmlAssert asXml() {
        this.isNotNull();
        return XmlAssert.assertThat(this.actual);
    }

    public ValueAssert isEqualTo(int expected) {
        this.asInt().isEqualTo(expected);
        return this;
    }

    public ValueAssert isEqualTo(double expected) {
        this.asDouble().isEqualTo(expected);
        return this;
    }

    public ValueAssert isEqualTo(boolean expected) {
        this.asBoolean().isEqualTo(expected);
        return this;
    }
}

