/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.util.X509Util;
import org.xipki.util.LruCache;
import org.xipki.util.StringUtil;
import org.xipki.util.http.XiHttpRequest;

public class TlsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TlsHelper.class);
    private static final LruCache<String, X509Cert> clientCerts = new LruCache(50);
    private static final LruCache<Reference, X509Cert> clientCerts0 = new LruCache(50);
    private static final int PROXY_MODE_GENERAL = 1;
    private static final int PROXY_MODE_NO = 0;
    private static final int reverseProxyMode;

    public static X509Cert getTlsClientCert(XiHttpRequest request) throws IOException {
        if (reverseProxyMode == 0) {
            X509Certificate[] certs = request.getCertificateChain();
            if (certs == null || certs.length < 1) {
                return null;
            }
            X509Certificate cert0 = certs[0];
            Reference ref = new Reference(cert0);
            X509Cert cert = (X509Cert)clientCerts0.get((Object)ref);
            if (cert == null) {
                cert = new X509Cert(cert0);
                clientCerts0.put((Object)ref, (Object)cert);
            }
            return cert;
        }
        String clientVerify = request.getHeader("SSL_CLIENT_VERIFY");
        LOG.debug("SSL_CLIENT_VERIFY: '{}'", (Object)clientVerify);
        if (StringUtil.isBlank((String)clientVerify)) {
            return null;
        }
        if (!"SUCCESS".equalsIgnoreCase(clientVerify.trim())) {
            return null;
        }
        String pemClientCert = request.getHeader("SSL_CLIENT_CERT");
        if (pemClientCert == null || pemClientCert.length() < 100) {
            LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemClientCert);
            return null;
        }
        X509Cert clientCert = (X509Cert)clientCerts.get((Object)pemClientCert);
        if (clientCert != null) {
            return clientCert;
        }
        try {
            clientCert = X509Util.parseCert(StringUtil.toUtf8Bytes((String)pemClientCert));
        }
        catch (CertificateException ex) {
            LOG.error("SSL_CLIENT_CERT: '{}'", (Object)pemClientCert);
            throw new IOException("could not parse Certificate", ex);
        }
        clientCerts.put((Object)pemClientCert, (Object)clientCert);
        return clientCert;
    }

    static {
        String propName = "org.xipki.reverseproxy.mode";
        String mode = System.getProperty(propName);
        if (mode != null && !mode.trim().isEmpty()) {
            mode = mode.trim().toUpperCase();
        }
        if (mode == null || "NO".equals(mode)) {
            reverseProxyMode = 0;
        } else if ("APACHE".equals(mode) || "NGINX".equals(mode) || "GENERAL".equals(mode)) {
            reverseProxyMode = 1;
        } else {
            LOG.error("ignored invalid value of property {}: {} is not one of [NO, GENERAL, APACHE, NGINX]", (Object)propName, (Object)mode);
            reverseProxyMode = 0;
        }
        LOG.info("set reverseProxyMode to {}", (Object)reverseProxyMode);
    }

    private static class Reference {
        private final Object obj;

        Reference(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof Reference) {
                return this.obj == ((Reference)another).obj;
            }
            return false;
        }
    }
}

