/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;

public class JSON {
    private static final ObjectMapper json = new ObjectMapper().registerModule((Module)XiJsonModule.INSTANCE).configure(JsonParser.Feature.ALLOW_COMMENTS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final ObjectWriter prettyJson = new ObjectMapper().registerModule((Module)XiJsonModule.INSTANCE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(JsonParser.Feature.ALLOW_COMMENTS, true).writerWithDefaultPrettyPrinter();

    public static <T> T parseObject(String json, Class<T> classOfT) {
        try {
            return (T)JSON.json.readValue(json, classOfT);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(byte[] json, Class<T> classOfT) {
        try {
            return (T)JSON.json.readValue(json, classOfT);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(Path jsonFilePath, Class<T> classOfT) throws IOException {
        return (T)json.readValue(jsonFilePath.toFile(), classOfT);
    }

    public static <T> T parseObject(File jsonFile, Class<T> classOfT) throws IOException {
        return (T)json.readValue(jsonFile, classOfT);
    }

    public static <T> T parseObject(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        InputStreamReader noCloseReader = new InputStreamReader(jsonInputStream){

            @Override
            public void close() {
            }
        };
        return (T)json.readValue((Reader)noCloseReader, classOfT);
    }

    public static <T> T parseObjectAndClose(InputStream jsonInputStream, Class<T> classOfT) throws IOException {
        return (T)json.readValue((Reader)new InputStreamReader(jsonInputStream), classOfT);
    }

    public static String toJson(Object obj) {
        try {
            return json.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toJSONBytes(Object obj) {
        try {
            return json.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJson(Object obj) {
        try {
            return prettyJson.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(JSON.toJSONBytes(object));
    }

    public static void writeJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        json.writeValue(outputStream, object);
    }

    public static void writePrettyJSON(Object object, OutputStream outputStream) throws IOException {
        outputStream.write(JSON.toPrettyJson(object).getBytes(StandardCharsets.UTF_8));
    }

    public static void writePrettyJSONAndClose(Object object, OutputStream outputStream) throws IOException {
        prettyJson.writeValue(outputStream, object);
    }

    public static class XiJsonModule
    extends SimpleModule {
        public static final XiJsonModule INSTANCE = new XiJsonModule();

        public XiJsonModule() {
            this.addSerializer(Instant.class, new InstantSerializer());
            this.addDeserializer(Instant.class, new InstantDeserializer());
        }
    }

    private static class InstantDeserializer
    extends JsonDeserializer<Instant> {
        private InstantDeserializer() {
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return Instant.parse(jsonParser.getValueAsString());
        }
    }

    private static class InstantSerializer
    extends JsonSerializer<Instant> {
        private InstantSerializer() {
        }

        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(instant.toString());
        }
    }
}

