/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.security.spec.DSAParameterSpec;
import java.util.HashSet;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.xipki.password.PasswordResolver;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.EdECConstants;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.Args;
import org.xipki.util.ConfPairs;

public class P11KeypairGenerator
extends KeypairGenerator {
    protected final P11CryptServiceFactory cryptServiceFactory;
    protected P11Slot slot;

    public P11KeypairGenerator(P11CryptServiceFactory cryptServiceFactory) {
        this.cryptServiceFactory = (P11CryptServiceFactory)Args.notNull((Object)cryptServiceFactory, (String)"cryptService");
    }

    @Override
    public void initialize0(ConfPairs conf, PasswordResolver passwordResolver) throws XiSecurityException {
        Long slotId;
        String moduleName = ((ConfPairs)Args.notNull((Object)conf, (String)"conf")).value("module");
        String str = conf.value("slot");
        Integer slotIndex = str == null ? null : Integer.valueOf(Integer.parseInt(str));
        str = conf.value("slot-id");
        Long l = slotId = str == null ? null : Long.valueOf(Long.parseLong(str));
        if (slotIndex == null && slotId == null || slotIndex != null && slotId != null) {
            throw new XiSecurityException("exactly one of slot (index) and slot-id must be specified");
        }
        try {
            P11CryptService p11Service = this.cryptServiceFactory.getP11CryptService(moduleName);
            P11Module module = p11Service.getModule();
            P11SlotId p11SlotId = slotId != null ? module.getSlotIdForId(slotId) : module.getSlotIdForIndex(slotIndex);
            this.slot = module.getSlot(p11SlotId);
            HashSet<String> set = new HashSet<String>();
            for (String m : this.keyspecs) {
                String[] tokens = m.split("/");
                switch (tokens[0]) {
                    case "RSA": {
                        if (!this.slot.supportsMechanism(0L, 65536L)) break;
                        set.add(m);
                        break;
                    }
                    case "DSA": {
                        if (!this.slot.supportsMechanism(16L, 65536L)) break;
                        set.add(m);
                        break;
                    }
                    case "EC": {
                        if (!this.slot.supportsMechanism(4160L, 65536L)) break;
                        if (GMObjectIdentifiers.sm2p256v1.getId().equals(tokens[1])) {
                            if (!this.slot.supportsMechanism(0xFFFFF001L, 65536L)) break;
                            set.add(m);
                            break;
                        }
                        set.add(m);
                        break;
                    }
                    case "ED25519": 
                    case "ED448": {
                        if (!this.slot.supportsMechanism(4181L, 65536L)) break;
                        set.add(m);
                        break;
                    }
                    case "X25519": 
                    case "X448": {
                        if (!this.slot.supportsMechanism(4182L, 65536L)) break;
                        set.add(m);
                    }
                }
            }
            this.keyspecs.clear();
            this.keyspecs.addAll(set);
        }
        catch (TokenException ex) {
            throw new XiSecurityException("cannot get the slot", ex);
        }
    }

    @Override
    public PrivateKeyInfo generateKeypair(String keyspec) throws XiSecurityException {
        if (!this.supports(keyspec)) {
            throw new XiSecurityException(this.name + " cannot generate keypair of keyspec " + keyspec);
        }
        String[] tokens = keyspec.split("/");
        String type = tokens[0].toUpperCase(Locale.ROOT);
        try {
            switch (type) {
                case "RSA": {
                    int keysize = Integer.parseInt(tokens[1]);
                    if (keysize > 4096) {
                        throw new XiSecurityException("keysize too large");
                    }
                    return this.slot.generateRSAKeypairOtf(keysize, this.rsaE);
                }
                case "EC": {
                    String curveOid = tokens[1];
                    if (curveOid.equals(GMObjectIdentifiers.sm2p256v1.getId())) {
                        return this.slot.generateSM2KeypairOtf();
                    }
                    return this.slot.generateECKeypairOtf(new ASN1ObjectIdentifier(curveOid));
                }
                case "DSA": {
                    int pLength = Integer.parseInt(tokens[1]);
                    int qLength = Integer.parseInt(tokens[2]);
                    DSAParameterSpec spec = DSAParameterCache.getDSAParameterSpec(pLength, qLength, null);
                    return this.slot.generateDSAKeypairOtf0(spec.getP(), spec.getQ(), spec.getG());
                }
                case "ED25519": 
                case "ED448": {
                    ASN1ObjectIdentifier curveId = EdECConstants.getCurveOid(keyspec);
                    return this.slot.doGenerateECEdwardsKeypairOtf(curveId);
                }
                case "X25519": 
                case "X448": {
                    ASN1ObjectIdentifier curveId = EdECConstants.getCurveOid(keyspec);
                    return this.slot.doGenerateECMontgomeryKeypairOtf(curveId);
                }
            }
            throw new IllegalArgumentException("unknown keyspec " + keyspec);
        }
        catch (TokenException ex) {
            throw new XiSecurityException("error generateKeypair for keyspec " + keyspec, ex);
        }
    }

    @Override
    public boolean isHealthy() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

