/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.pkcs11.wrapper.AttributeVector;
import org.xipki.pkcs11.wrapper.Functions;
import org.xipki.pkcs11.wrapper.KeyPairTemplate;
import org.xipki.pkcs11.wrapper.Mechanism;
import org.xipki.pkcs11.wrapper.MechanismInfo;
import org.xipki.pkcs11.wrapper.ModuleInfo;
import org.xipki.pkcs11.wrapper.PKCS11Constants;
import org.xipki.pkcs11.wrapper.PKCS11Exception;
import org.xipki.pkcs11.wrapper.PKCS11Key;
import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.PKCS11KeyPair;
import org.xipki.pkcs11.wrapper.PKCS11Module;
import org.xipki.pkcs11.wrapper.PKCS11Token;
import org.xipki.pkcs11.wrapper.Token;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.pkcs11.wrapper.params.ByteArrayParams;
import org.xipki.pkcs11.wrapper.params.CkParams;
import org.xipki.pkcs11.wrapper.params.CkParamsWithExtra;
import org.xipki.pkcs11.wrapper.params.ExtraParams;
import org.xipki.pkcs11.wrapper.params.RSA_PKCS_PSS_PARAMS;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.NativeP11Key;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotId;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

class NativeP11Slot
extends P11Slot {
    public static final AlgorithmIdentifier ALGID_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
    private static final Logger LOG = LoggerFactory.getLogger(NativeP11Slot.class);
    private final PKCS11Token token;
    private final SecureRandom random = new SecureRandom();
    private final long rsaKeyPairGenMech;
    private String libDesc;

    NativeP11Slot(String moduleName, P11SlotId slotId, PKCS11Token token, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, List<Long> secretKeyTypes, List<Long> keyPairTypes) throws TokenException {
        super(moduleName, slotId, token.isReadOnly(), secretKeyTypes, keyPairTypes, newObjectConf);
        if (slotId.getId() != token.getTokenId()) {
            throw new IllegalArgumentException("slotId != token.getTokenId");
        }
        this.token = (PKCS11Token)Args.notNull((Object)token, (String)"slot");
        ModuleInfo moduleInfo = token.getModule().getInfo();
        this.libDesc = moduleInfo.getLibraryDescription();
        if (this.libDesc == null) {
            this.libDesc = "";
        }
        this.initMechanisms(this.getSupportedMechanisms(), mechanismFilter);
        this.rsaKeyPairGenMech = this.supportsMechanism(10L, 65536L) ? 10L : 0L;
    }

    private Map<Long, MechanismInfo> getSupportedMechanisms() {
        Set mechanisms = this.token.getMechanisms();
        ArrayList<Long> newList = new ArrayList<Long>(mechanisms.size());
        StringBuilder ignoreMechs = new StringBuilder();
        boolean smartcard = this.libDesc.toLowerCase().contains("smartcard");
        Iterator iterator = mechanisms.iterator();
        while (iterator.hasNext()) {
            long code = (Long)iterator.next();
            if (smartcard) {
                if (code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L) {
                    ignoreMechs.append(PKCS11Constants.ckmCodeToName((long)code)).append(", ");
                    continue;
                }
                newList.add(code);
                continue;
            }
            newList.add(code);
        }
        if (ignoreMechs.length() > 0) {
            LOG.info("Ignore mechanisms in smartcard-based HSM: {}", (Object)ignoreMechs.substring(0, ignoreMechs.length() - 2));
        }
        HashMap<Long, MechanismInfo> ret = new HashMap<Long, MechanismInfo>(newList.size() * 5 / 4);
        for (Long mech : newList) {
            MechanismInfo info = this.token.getMechanismInfo(mech.longValue());
            if (info == null) {
                LOG.warn("found not MechanismInfo for " + PKCS11Constants.ckmCodeToName((long)mech) + ", ignore it");
                continue;
            }
            ret.put(mech, info);
        }
        return ret;
    }

    @Override
    protected PKCS11Module getPKCS11Module() {
        return this.token.getModule();
    }

    @Override
    protected String mechanismCodeToName(long code) {
        return this.token.getModule().codeToName(PKCS11Constants.Category.CKM, code);
    }

    @Override
    public boolean supportsMechanism(long mechanism, long flagBit) {
        long genericCode;
        MechanismInfo info = (MechanismInfo)this.mechanisms.get(mechanism);
        if (info == null && (genericCode = this.token.getModule().vendorToGenericCode(PKCS11Constants.Category.CKM, mechanism)) != mechanism) {
            info = (MechanismInfo)this.mechanisms.get(mechanism);
        }
        return info != null && info.hasFlagBit(flagBit);
    }

    @Override
    public final void close() {
        this.token.closeAllSessions();
    }

    byte[] digestSecretKey(long mech, NativeP11Key identity) throws TokenException {
        if (!identity.isSecretKey()) {
            throw new TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        long keyHandle = ((NativeP11Key)Args.notNull((Object)identity, (String)"identity")).getKeyId().getHandle();
        this.assertMechanismSupported(mech, 1024L);
        return this.token.digestKey(new Mechanism(mech), keyHandle);
    }

    byte[] sign(long mech, P11Params parameters, byte[] content, NativeP11Key identity) throws TokenException {
        Args.notNull((Object)content, (String)"content");
        this.assertMechanismSupported(mech, 2048L);
        long signingKeyHandle = identity.getKeyId().getHandle();
        return this.token.sign(this.getMechanism(mech, parameters, identity), signingKeyHandle, content);
    }

    @Override
    public P11Key getKey(PKCS11KeyId keyId) throws TokenException {
        PKCS11Key pkcs11Key = this.token.getKey(keyId);
        return pkcs11Key == null ? null : this.toIdentity(pkcs11Key);
    }

    @Override
    public P11Key getKey(byte[] keyId, String keyLabel) throws TokenException {
        PKCS11Key pkcs11Key;
        if ((keyId == null || keyId.length == 0) && StringUtil.isBlank((String)keyLabel)) {
            return null;
        }
        AttributeVector criteria = new AttributeVector();
        if (keyId != null && keyId.length > 0) {
            criteria.id(keyId);
        }
        if (StringUtil.isNotBlank((String)keyLabel)) {
            criteria.label(keyLabel);
        }
        return (pkcs11Key = this.token.getKey(criteria)) == null ? null : this.toIdentity(pkcs11Key);
    }

    @Override
    public PKCS11KeyId getKeyId(byte[] keyId, String keyLabel) throws TokenException {
        PKCS11KeyId objectId;
        if ((keyId == null || keyId.length == 0) && StringUtil.isBlank((String)keyLabel)) {
            return null;
        }
        AttributeVector criteria = new AttributeVector();
        if (keyId != null && keyId.length > 0) {
            criteria.id(keyId);
        }
        if (StringUtil.isNotBlank((String)keyLabel)) {
            criteria.label(keyLabel);
        }
        if ((objectId = this.token.getKeyId(criteria)) == null) {
            return null;
        }
        long objClass = objectId.getObjectCLass();
        if (objClass != 3L && objClass != 4L) {
            throw new TokenException("could not find private key or secret key for " + NativeP11Slot.getDescription(keyId, keyLabel));
        }
        return objectId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private P11Key toIdentity(PKCS11Key pkcs11Key) throws TokenException {
        PKCS11KeyId keyId = pkcs11Key.id();
        NativeP11Key p11Identity = new NativeP11Key(this, keyId);
        long objClass = keyId.getObjectCLass();
        long keyType = keyId.getKeyType();
        if (objClass == 3L) {
            if (keyType == 0L) {
                p11Identity.setRsaMParameters(pkcs11Key.rsaModulus(), pkcs11Key.rsaPublicExponent());
                return p11Identity.sign(pkcs11Key.sign());
            } else if (keyType == 1L) {
                p11Identity.setDsaParameters(pkcs11Key.dsaPrime(), pkcs11Key.dsaSubprime(), pkcs11Key.dsaBase());
                return p11Identity.sign(pkcs11Key.sign());
            } else {
                if (keyType != 3L && keyType != 0xFFFFF001L && keyType != 64L && keyType != 65L) throw new IllegalStateException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
                ASN1ObjectIdentifier curveId = NativeP11Slot.detectCurveOid(pkcs11Key.ecParams());
                if (curveId == null && keyId.getPublicKeyHandle() != null) {
                    byte[] ecParams = this.token.getAttrValues(keyId.getPublicKeyHandle().longValue(), new long[]{384L}).ecParams();
                    curveId = NativeP11Slot.detectCurveOid(ecParams);
                }
                if (curveId == null) return p11Identity.sign(pkcs11Key.sign());
                p11Identity.setEcParams(curveId);
            }
            return p11Identity.sign(pkcs11Key.sign());
        } else {
            if (objClass == 4L) return p11Identity.sign(pkcs11Key.sign());
            throw new IllegalStateException("unknown object class " + PKCS11Constants.ckoCodeToName((long)objClass));
        }
    }

    @Override
    protected PublicKey getPublicKey(P11Key identity) throws TokenException {
        Long publicKeyHandle = identity.getKeyId().getPublicKeyHandle();
        if (publicKeyHandle == null) {
            return null;
        }
        long keyType = identity.getKeyType();
        if (keyType == 0L) {
            return this.buildRSAKey(identity.getRsaModulus(), identity.getRsaPublicExponent());
        }
        if (keyType == 1L) {
            AttributeVector attrs = this.token.getAttrValues(publicKeyHandle.longValue(), new long[]{17L});
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, attrs.value()), identity.getDsaP(), identity.getDsaQ(), identity.getDsaG());
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        if (keyType == 3L || keyType == 0xFFFFF001L || keyType == 64L || keyType == 65L) {
            byte[] ecPoint = this.token.getAttrValues(publicKeyHandle.longValue(), new long[]{385L}).ecPoint();
            ASN1ObjectIdentifier curveOid = identity.getEcParams();
            if (keyType == 64L || keyType == 65L) {
                if (keyType == 64L) {
                    if (!EdECConstants.isEdwardsCurve(curveOid)) {
                        throw new TokenException("unknown Edwards curve OID " + curveOid);
                    }
                } else if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                    throw new TokenException("unknown Montgomery curve OID " + curveOid);
                }
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(curveOid), ecPoint);
                try {
                    return KeyUtil.generatePublicKey(pkInfo);
                }
                catch (InvalidKeySpecException ex) {
                    throw new TokenException(ex.getMessage(), (Exception)ex);
                }
            }
            try {
                return KeyUtil.createECPublicKey(curveOid, ecPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
        }
        throw new TokenException("unknown key type " + PKCS11Constants.ckkCodeToName((long)keyType));
    }

    @Override
    public boolean objectExistsByIdLabel(byte[] id, String label) throws TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            return false;
        }
        AttributeVector template = new AttributeVector();
        if (id != null && id.length > 0) {
            template.id(id);
        }
        if (!StringUtil.isBlank((String)label)) {
            template.label(label);
        }
        return !this.getObjects(template, 1).isEmpty();
    }

    @Override
    public int destroyAllObjects() {
        try {
            long[] handles = this.token.findAllObjects(null);
            return this.token.destroyObjects(handles).length;
        }
        catch (TokenException e) {
            LogUtil.warn((Logger)LOG, (Throwable)e, (String)"error destroyAllObjects()");
            return 0;
        }
    }

    @Override
    public long[] destroyObjectsByHandle(long[] handles) {
        List destroyedHandles;
        ArrayList<Long> handleList = new ArrayList<Long>(handles.length);
        for (long handle : handles) {
            handleList.add(handle);
        }
        try {
            destroyedHandles = this.token.destroyObjects(handleList);
        }
        catch (TokenException e) {
            return handles;
        }
        if (handles.length == destroyedHandles.size()) {
            return new long[0];
        }
        long[] failedHandles = new long[handles.length - destroyedHandles.size()];
        int index = 0;
        for (long handle : handles) {
            if (destroyedHandles.contains(handle)) continue;
            failedHandles[index++] = handle;
        }
        return failedHandles;
    }

    @Override
    public int destroyObjectsByIdLabel(byte[] id, String label) throws TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        AttributeVector template = new AttributeVector();
        if (id != null && id.length > 0) {
            template.id(id);
        }
        if (label != null && !label.isEmpty()) {
            template.label(label);
        }
        return this.removeObjects0(template, "objects " + NativeP11Slot.getDescription(id, label));
    }

    @Override
    protected PKCS11KeyId doGenerateSecretKey(long keyType, Integer keysize, P11Slot.P11NewKeyControl control) throws TokenException {
        String label;
        long mech;
        if (keysize != null && keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        boolean hasValueLen = true;
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
            hasValueLen = false;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type 0x" + PKCS11Constants.codeToName((PKCS11Constants.Category)PKCS11Constants.Category.CKK, (long)keyType));
        }
        this.assertMechanismSupported(mech, 32768L);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            label = null;
        } else {
            label = control.getLabel();
        }
        byte[] id = control.getId();
        AttributeVector template = AttributeVector.newSecretKey((long)keyType);
        this.setKeyAttributes(control, template, label);
        if (hasValueLen) {
            if (keysize == null) {
                throw new IllegalArgumentException("keysize must not be null");
            }
            template.valueLen(Integer.valueOf(keysize / 8));
        }
        Mechanism mechanism = new Mechanism(mech);
        if (label != null && this.labelExists(label)) {
            throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
        }
        if (id == null) {
            id = this.generateId();
        }
        long keyHandle = this.token.generateKey(mechanism, template.id(id));
        label = this.token.getAttrValues(keyHandle, new long[]{3L}).label();
        return new PKCS11KeyId(keyHandle, 4L, keyType, id, label);
    }

    @Override
    protected PKCS11KeyId doImportSecretKey(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws TokenException {
        String label;
        AttributeVector template = AttributeVector.newSecretKey((long)keyType);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            label = null;
        } else {
            label = control.getLabel();
        }
        this.setKeyAttributes(control, template, label);
        if (label != null && this.labelExists(label)) {
            throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
        }
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        long keyHandle = this.token.createObject(template.value(keyValue).id(id));
        try {
            label = this.token.getAttrValues(keyHandle, new long[]{3L}).label();
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        return new PKCS11KeyId(keyHandle, 4L, keyType, id, label);
    }

    @Override
    protected PKCS11KeyId doGenerateRSAKeypair(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(0L);
        template.publicKey().modulusBits(Integer.valueOf(keysize));
        if (publicExponent != null) {
            template.publicKey().publicExponent(publicExponent);
        }
        this.setKeyPairAttributes(control, template, this.newObjectConf);
        return this.doGenerateKeyPair(this.rsaKeyPairGenMech, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(0L);
        template.publicKey().modulusBits(Integer.valueOf(keysize));
        if (publicExponent != null) {
            template.publicKey().publicExponent(publicExponent);
        }
        NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
        long mech = this.rsaKeyPairGenMech;
        PKCS11KeyPair keypair = null;
        try {
            keypair = this.token.generateKeyPair(new Mechanism(mech), template);
            AttributeVector attrs = this.token.getAttrValues(keypair.getPrivateKey(), new long[]{288L, 290L, 291L, 292L, 293L, 294L, 295L, 296L});
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(ALGID_RSA, (ASN1Encodable)new RSAPrivateKey(attrs.modulus(), attrs.publicExponent(), attrs.privateExponent(), attrs.prime1(), attrs.prime2(), attrs.exponent1(), attrs.exponent2(), attrs.coefficient()));
            this.destroyKeyPairQuietly(keypair);
            return privateKeyInfo;
        }
        catch (IOException | PKCS11Exception ex) {
            try {
                throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
            }
            catch (Throwable throwable) {
                this.destroyKeyPairQuietly(keypair);
                throw throwable;
            }
        }
    }

    @Override
    protected PKCS11KeyId doGenerateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(1L);
        template.publicKey().prime(p).subprime(q).base(g);
        this.setKeyPairAttributes(control, template, this.newObjectConf);
        return this.doGenerateKeyPair(16L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(1L);
        NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
        template.publicKey().prime(p).subprime(q).base(g);
        long mech = 16L;
        PKCS11KeyPair keypair = null;
        try {
            DSAParameter parameter = new DSAParameter(p, q, g);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
            keypair = this.token.generateKeyPair(new Mechanism(mech), template);
            long skHandle = keypair.getPrivateKey();
            long pkHandle = keypair.getPublicKey();
            BigInteger p11PublicKeyValue = new BigInteger(1, this.token.getAttrValues(pkHandle, new long[]{17L}).value());
            BigInteger p11PrivateKeyValue = new BigInteger(1, this.token.getAttrValues(skHandle, new long[]{17L}).value());
            byte[] publicKey = new ASN1Integer(p11PublicKeyValue).getEncoded();
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(p11PrivateKeyValue), null, publicKey);
            this.destroyKeyPairQuietly(keypair);
            return privateKeyInfo;
        }
        catch (IOException | PKCS11Exception ex) {
            try {
                throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
            }
            catch (Throwable throwable) {
                this.destroyKeyPairQuietly(keypair);
                throw throwable;
            }
        }
    }

    @Override
    protected PKCS11KeyId doGenerateECEdwardsKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        byte[] encodedCurveId;
        KeyPairTemplate template = new KeyPairTemplate(64L);
        this.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        template.publicKey().ecParams(encodedCurveId);
        return this.doGenerateKeyPair(4181L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECEdwardsKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(64L, 4181L, curveId);
    }

    @Override
    protected PKCS11KeyId doGenerateECMontgomeryKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        KeyPairTemplate template = new KeyPairTemplate(65L);
        this.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            template.publicKey().ecParams(curveId.getEncoded());
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        return this.doGenerateKeyPair(4182L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECMontgomeryKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(65L, 4182L, curveId);
    }

    @Override
    protected PKCS11KeyId doGenerateECKeypair(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws TokenException {
        byte[] encodedCurveId;
        KeyPairTemplate template = new KeyPairTemplate(3L);
        this.setKeyPairAttributes(control, template, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
        template.publicKey().ecParams(encodedCurveId);
        return this.doGenerateKeyPair(4160L, control.getId(), template);
    }

    @Override
    protected PrivateKeyInfo doGenerateECKeypairOtf(ASN1ObjectIdentifier curveId) throws TokenException {
        return this.doGenerateECKeypairOtf(3L, 4160L, curveId);
    }

    private PrivateKeyInfo doGenerateECKeypairOtf(long keyType, long mech, ASN1ObjectIdentifier curveId) throws TokenException {
        byte[] privValue;
        byte[] ecPoint;
        PKCS11KeyPair keypair;
        byte[] ecParams;
        block10: {
            if (keyType == 0xFFFFF001L && !GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveId)) {
                throw new TokenException("keyType and curveId do not match.");
            }
            KeyPairTemplate template = new KeyPairTemplate(keyType);
            NativeP11Slot.setPrivateKeyAttrsOtf(template.privateKey());
            try {
                ecParams = curveId.getEncoded();
            }
            catch (IOException ex) {
                throw new TokenException(ex.getMessage(), (Exception)ex);
            }
            template.publicKey().ecParams(ecParams);
            keypair = null;
            keypair = this.token.generateKeyPair(new Mechanism(mech), template);
            ecPoint = this.token.getAttrValues(keypair.getPublicKey(), new long[]{385L}).ecPoint();
            privValue = this.token.getAttrValues(keypair.getPrivateKey(), new long[]{17L}).value();
            if (64L != keyType && 65L != keyType) break block10;
            AlgorithmIdentifier algId = new AlgorithmIdentifier(curveId);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new DEROctetString(privValue), null, ecPoint);
            this.destroyKeyPairQuietly(keypair);
            return privateKeyInfo;
        }
        try {
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveId);
            if (ecPoint[0] != 4) {
                throw new TokenException("EcPoint does not start with 0x04");
            }
            Integer orderBitLen = Functions.getCurveOrderBitLength((byte[])ecParams);
            if (orderBitLen == null) {
                throw new TokenException("unknown curve " + curveId.getId());
            }
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new ECPrivateKey(orderBitLen.intValue(), new BigInteger(1, privValue), (ASN1BitString)new DERBitString(ecPoint), null));
            this.destroyKeyPairQuietly(keypair);
            return privateKeyInfo;
        }
        catch (IOException | PKCS11Exception ex) {
            try {
                throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)ex);
            }
            catch (Throwable throwable) {
                this.destroyKeyPairQuietly(keypair);
                throw throwable;
            }
        }
    }

    @Override
    protected PKCS11KeyId doGenerateSM2Keypair(P11Slot.P11NewKeyControl control) throws TokenException {
        long ckm = 0xFFFFF001L;
        if (this.supportsMechanism(ckm, 65536L)) {
            KeyPairTemplate template = new KeyPairTemplate(0xFFFFF001L);
            template.publicKey().ecParams(Hex.decode((String)"06082A811CCF5501822D"));
            this.setKeyPairAttributes(control, template, this.newObjectConf);
            return this.doGenerateKeyPair(ckm, control.getId(), template);
        }
        return this.doGenerateECKeypair(GMObjectIdentifiers.sm2p256v1, control);
    }

    @Override
    protected PrivateKeyInfo doGenerateSM2KeypairOtf() throws TokenException {
        long ckm = 0xFFFFF001L;
        return this.supportsMechanism(ckm, 65536L) ? this.doGenerateECKeypairOtf(0xFFFFF001L, ckm, GMObjectIdentifiers.sm2p256v1) : this.doGenerateECKeypairOtf(GMObjectIdentifiers.sm2p256v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PKCS11KeyId doGenerateKeyPair(long mech, byte[] id, KeyPairTemplate template) throws TokenException {
        long keyType = template.privateKey().keyType();
        String label = template.privateKey().label();
        boolean succ = false;
        try {
            PKCS11KeyPair keypair;
            if (label != null && this.labelExists(label)) {
                throw new IllegalArgumentException("label " + label + " exists, please specify another one");
            }
            if (id == null) {
                id = this.generateId();
            }
            template.id(id);
            try {
                keypair = this.token.generateKeyPair(new Mechanism(mech), template);
            }
            catch (PKCS11Exception ex) {
                if (mech == 4160L) {
                    ASN1ObjectIdentifier curveId = ASN1ObjectIdentifier.getInstance((Object)template.publicKey().ecParams());
                    X9ECParameters ecParams = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveId);
                    if (ecParams == null) {
                        throw ex;
                    }
                    try {
                        template.publicKey().ecParams(ecParams.getEncoded());
                    }
                    catch (IOException ex2) {
                        throw ex;
                    }
                    keypair = this.token.generateKeyPair(new Mechanism(mech), template);
                }
                throw new TokenException("could not generate keypair " + PKCS11Constants.ckmCodeToName((long)mech), (Exception)((Object)ex));
            }
            PKCS11KeyId objectId = new PKCS11KeyId(keypair.getPrivateKey(), 3L, keyType, id, label);
            objectId.setPublicKeyHandle(Long.valueOf(keypair.getPublicKey()));
            succ = true;
            PKCS11KeyId pKCS11KeyId = objectId;
            return pKCS11KeyId;
        }
        finally {
            if (!succ && id != null) {
                try {
                    this.destroyObjectsByIdLabel(id, label);
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove objects");
                }
            }
        }
    }

    @Override
    public void showDetails(OutputStream stream, Long objectHandle, boolean verbose) throws IOException {
        block11: {
            String slotInfo;
            String tokenInfo;
            Token underlyingToken = this.token.getToken();
            try {
                tokenInfo = underlyingToken.getTokenInfo().toString("  ");
            }
            catch (PKCS11Exception ex) {
                tokenInfo = "  ERROR";
            }
            try {
                slotInfo = underlyingToken.getSlot().getSlotInfo().toString("  ");
            }
            catch (PKCS11Exception ex) {
                slotInfo = "  ERROR";
            }
            stream.write(("\nToken information:\n" + tokenInfo).getBytes(StandardCharsets.UTF_8));
            stream.write(("\n\nSlot information:\n" + slotInfo).getBytes(StandardCharsets.UTF_8));
            stream.write(10);
            if (verbose) {
                this.printSupportedMechanism(stream);
            }
            try {
                if (objectHandle != null) {
                    stream.write(("\nDetails of object with handle " + objectHandle + "\n").getBytes(StandardCharsets.UTF_8));
                    AttributeVector attrs = this.token.getDefaultAttrValues(objectHandle.longValue());
                    stream.write(attrs.toString(false, "  ").getBytes(StandardCharsets.UTF_8));
                    break block11;
                }
                stream.write("\nList of objects:\n".getBytes(StandardCharsets.UTF_8));
                long[] handles = this.token.findObjects(null, 9999);
                int i = 0;
                for (long handle : handles) {
                    String text;
                    ++i;
                    try {
                        String objectText = this.objectToString(handle);
                        text = StringUtil.formatAccount((long)i, (int)3) + ". " + objectText;
                    }
                    catch (Exception ex) {
                        text = StringUtil.formatAccount((long)i, (int)3) + ". Error reading object with handle " + handle;
                        LOG.debug(text, (Throwable)ex);
                    }
                    stream.write(("  " + text + "\n").getBytes(StandardCharsets.UTF_8));
                    if (i % 10 != 0) continue;
                    stream.flush();
                }
            }
            catch (TokenException e) {
                String message = "  error: " + e.getMessage();
                stream.write(message.getBytes(StandardCharsets.UTF_8));
                LogUtil.warn((Logger)LOG, (Throwable)e, (String)message);
            }
        }
        stream.flush();
    }

    private String objectToString(long handle) throws TokenException {
        AttributeVector attrs = this.token.getAttrValues(handle, new long[]{258L, 3L, 0L});
        Long objClass = attrs.class_();
        if (objClass == null) {
            throw new TokenException("CKA_CLASS is not present.");
        }
        byte[] id = attrs.id();
        String label = attrs.label();
        Object keySpec = null;
        if (objClass == 3L || objClass == 2L || objClass == 4L) {
            long keyType = this.token.getAttrValues(handle, new long[]{256L}).keyType();
            if (objClass == 4L) {
                Integer len;
                int valueLen = keyType == 21L ? 24 : ((len = this.token.getAttrValues(handle, new long[]{353L}).valueLen()) == null ? 0 : len);
                keySpec = PKCS11Constants.ckkCodeToName((long)keyType).substring(4) + "/" + valueLen * 8;
            } else if (keyType == 0L) {
                BigInteger modulus = this.token.getAttrValues(handle, new long[]{288L}).modulus();
                keySpec = "RSA/" + (Serializable)(modulus == null ? "<N/A>" : Integer.valueOf(modulus.bitLength()));
            } else if (keyType == 3L || keyType == 64L || keyType == 65L) {
                Object curveName;
                byte[] ecParams = this.token.getAttrValues(handle, new long[]{384L}).ecParams();
                if (ecParams == null) {
                    curveName = "<N/A>";
                } else {
                    curveName = Functions.getCurveName((byte[])ecParams);
                    if (curveName == null) {
                        curveName = "0x" + NativeP11Slot.hex(ecParams);
                    }
                }
                keySpec = PKCS11Constants.ckkCodeToName((long)keyType).substring(4) + "/" + (String)curveName;
            } else {
                BigInteger prime;
                keySpec = keyType == 0xFFFFF001L ? "SM2" : (keyType == 1L ? "DSA/" + ((prime = this.token.getAttrValues(handle, new long[]{304L}).prime()) == null ? 0 : prime.bitLength()) : PKCS11Constants.ckkCodeToName((long)keyType).substring(4));
            }
        }
        String text = "handle=" + handle + ", id=" + (id == null ? "<N/A>" : NativeP11Slot.hex(id)) + ", label=" + (label == null ? "<N/A>" : label) + ", " + PKCS11Constants.ckoCodeToName((long)objClass).substring(4);
        if (keySpec != null) {
            text = text + ": " + keySpec;
        }
        return text;
    }

    private byte[] generateId() throws TokenException {
        return this.token.generateUniqueId(null, this.newObjectConf.getIdLength(), (Random)this.random);
    }

    private boolean labelExists(String keyLabel) throws TokenException {
        Args.notNull((Object)keyLabel, (String)"keyLabel");
        AttributeVector template = new AttributeVector().label(keyLabel);
        return CollectionUtil.isNotEmpty(this.getObjects(template, 1));
    }

    private static void setPrivateKeyAttrsOtf(AttributeVector privateKeyTemplate) {
        privateKeyTemplate.sensitive(Boolean.valueOf(false)).extractable(Boolean.valueOf(true)).token(Boolean.valueOf(false));
    }

    private void destroyKeyPairQuietly(PKCS11KeyPair keypair) {
        if (keypair != null) {
            try {
                this.token.destroyObject(keypair.getPrivateKey());
            }
            catch (TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("error destroying private key " + keypair.getPrivateKey()));
            }
            try {
                this.token.destroyObject(keypair.getPublicKey());
            }
            catch (TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("error destroying public key " + keypair.getPublicKey()));
            }
        }
    }

    private static ASN1ObjectIdentifier detectCurveOid(byte[] ecParams) {
        if (ecParams[0] == 6 && (0xFF & ecParams[1]) == ecParams.length - 2) {
            try {
                return ASN1ObjectIdentifier.getInstance((Object)ecParams);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private Mechanism getMechanism(long mechanism, P11Params parameters, P11Key identity) throws TokenException {
        ByteArrayParams paramObj;
        if (parameters == null) {
            return new Mechanism(mechanism);
        }
        if (parameters instanceof P11Params.P11RSAPkcsPssParams) {
            P11Params.P11RSAPkcsPssParams param = (P11Params.P11RSAPkcsPssParams)parameters;
            paramObj = new RSA_PKCS_PSS_PARAMS(param.getHashAlgorithm(), param.getMaskGenerationFunction(), param.getSaltLength());
        } else if (parameters instanceof P11Params.P11ByteArrayParams) {
            paramObj = new ByteArrayParams(((P11Params.P11ByteArrayParams)parameters).getBytes());
        } else {
            throw new TokenException("unknown P11Parameters " + parameters.getClass().getName());
        }
        if (identity.getEcOrderBitSize() != null) {
            paramObj = new CkParamsWithExtra((CkParams)paramObj, new ExtraParams().ecOrderBitSize(identity.getEcOrderBitSize().intValue()));
        }
        return new Mechanism(mechanism, (CkParams)paramObj);
    }

    private List<Long> getObjects(AttributeVector template) throws TokenException {
        return this.getObjects(template, 9999);
    }

    private List<Long> getObjects(AttributeVector template, int maxNo) throws TokenException {
        long[] objHandles;
        LinkedList<Long> objList = new LinkedList<Long>();
        for (long hObject : objHandles = this.token.findObjects(template, maxNo)) {
            objList.add(hObject);
        }
        return objList;
    }

    private RSAPublicKey buildRSAKey(BigInteger mod, BigInteger exp) throws TokenException {
        try {
            return KeyUtil.generateRSAPublicKey(new RSAPublicKeySpec(mod, exp));
        }
        catch (InvalidKeySpecException ex) {
            throw new TokenException(ex.getMessage(), (Exception)ex);
        }
    }

    private int removeObjects0(AttributeVector template, String desc) throws TokenException {
        try {
            List<Long> objects = this.getObjects(template);
            return this.token.destroyObjects(objects).size();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove " + desc));
            throw new TokenException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private void setKeyPairAttributes(P11Slot.P11NewKeyControl control, KeyPairTemplate template, P11ModuleConf.P11NewObjectConf newObjectConf) {
        Set<P11Slot.P11KeyUsage> usages;
        template.token(Boolean.valueOf(true));
        template.privateKey().private_(Boolean.valueOf(true));
        if (newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
        } else {
            template.labels(control.getLabel());
        }
        if (control.getExtractable() != null) {
            template.privateKey().extractable(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.privateKey().sensitive(control.getSensitive());
        }
        if (CollectionUtil.isNotEmpty(usages = control.getUsages())) {
            block7: for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.decryptEncrypt(Boolean.valueOf(true));
                        continue block7;
                    }
                    case DERIVE: {
                        template.derive(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN: {
                        template.signVerify(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN_RECOVER: {
                        template.signVerifyRecover(Boolean.valueOf(true));
                        continue block7;
                    }
                    case UNWRAP: {
                        template.unwrapWrap(Boolean.valueOf(true));
                        continue block7;
                    }
                }
                throw new IllegalStateException("unknown P11KeyUsage");
            }
        } else {
            long keyType = template.privateKey().keyType();
            if (keyType == 3L || keyType == 0L || keyType == 1L || keyType == 0xFFFFF001L) {
                template.signVerify(Boolean.valueOf(true));
            }
            if (keyType == 0L) {
                template.unwrapWrap(Boolean.valueOf(true)).decryptEncrypt(Boolean.valueOf(true));
            }
        }
    }

    private void setKeyAttributes(P11Slot.P11NewKeyControl control, AttributeVector template, String label) {
        Set<P11Slot.P11KeyUsage> usages;
        template.token(Boolean.valueOf(true));
        if (label != null) {
            template.label(label);
        }
        if (control.getExtractable() != null) {
            template.extractable(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.sensitive(control.getSensitive());
        }
        if (CollectionUtil.isNotEmpty(usages = control.getUsages())) {
            block7: for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.decrypt(Boolean.valueOf(true)).encrypt(Boolean.valueOf(true));
                        continue block7;
                    }
                    case DERIVE: {
                        template.derive(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN: {
                        template.sign(Boolean.valueOf(true)).verify(Boolean.valueOf(true));
                        continue block7;
                    }
                    case SIGN_RECOVER: {
                        template.signRecover(Boolean.valueOf(true)).verifyRecover(Boolean.valueOf(true));
                        continue block7;
                    }
                    case UNWRAP: {
                        template.unwrap(Boolean.valueOf(true)).wrap(Boolean.valueOf(true));
                        continue block7;
                    }
                }
                throw new IllegalStateException("unknown P11KeyUsage");
            }
        }
    }
}

