/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.pkcs11.wrapper.PKCS11KeyId;
import org.xipki.pkcs11.wrapper.TokenException;
import org.xipki.security.pkcs11.NativeP11Slot;
import org.xipki.security.pkcs11.P11Key;
import org.xipki.security.pkcs11.P11Params;

class NativeP11Key
extends P11Key {
    NativeP11Key(NativeP11Slot slot, PKCS11KeyId keyId) {
        super(slot, keyId);
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws TokenException {
        return ((NativeP11Slot)this.slot).digestSecretKey(mechanism, this);
    }

    @Override
    public void destroy() throws TokenException {
        if (this.keyId.getPublicKeyHandle() == null) {
            this.slot.destroyObjectsByHandle(this.keyId.getHandle());
        } else {
            this.slot.destroyObjectsByHandle(this.keyId.getHandle(), this.keyId.getPublicKeyHandle());
        }
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws TokenException {
        return ((NativeP11Slot)this.slot).sign(mechanism, parameters, content, this);
    }
}

