/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.Closeable;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.password.PasswordResolverException;
import org.xipki.password.Passwords;
import org.xipki.security.DfltKeypairGeneratorFactory;
import org.xipki.security.KeypairGeneratorFactory;
import org.xipki.security.KeypairGeneratorFactoryRegisterImpl;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SecurityFactoryImpl;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegisterImpl;
import org.xipki.security.pkcs11.NativeP11ModuleFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11CryptServiceFactoryImpl;
import org.xipki.security.pkcs11.P11ModuleFactory;
import org.xipki.security.pkcs11.P11ModuleFactoryRegisterImpl;
import org.xipki.security.pkcs11.P11SignerFactory;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.security.pkcs11.emulator.EmulatorP11ModuleFactory;
import org.xipki.security.pkcs12.P12SignerFactory;
import org.xipki.security.util.JSON;
import org.xipki.util.CollectionUtil;
import org.xipki.util.FileOrValue;
import org.xipki.util.ValidatableConf;
import org.xipki.util.exception.InvalidConfException;

public class Securities
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Securities.class);
    private P11ModuleFactoryRegisterImpl p11ModuleFactoryRegister;
    private P11CryptServiceFactoryImpl p11CryptServiceFactory;
    private SecurityFactoryImpl securityFactory;
    private final List<P11ModuleFactory> p11ModuleFactories;

    public Securities() {
        this(Securities.createDefaultFactories());
    }

    public Securities(List<P11ModuleFactory> p11ModuleFactories) {
        this.p11ModuleFactories = p11ModuleFactories != null ? new ArrayList<P11ModuleFactory>(p11ModuleFactories) : Collections.emptyList();
    }

    private static List<P11ModuleFactory> createDefaultFactories() {
        ArrayList<P11ModuleFactory> factories = new ArrayList<P11ModuleFactory>(3);
        factories.add(new NativeP11ModuleFactory());
        factories.add(new EmulatorP11ModuleFactory());
        return factories;
    }

    public SecurityFactory getSecurityFactory() {
        return this.securityFactory;
    }

    public P11CryptServiceFactory getP11CryptServiceFactory() {
        return this.p11CryptServiceFactory;
    }

    public void init() throws IOException, InvalidConfException {
        this.init(null);
    }

    public void init(SecurityConf conf) throws IOException, InvalidConfException {
        if (Security.getProvider("BC") == null) {
            LOG.info("add BouncyCastleProvider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            LOG.info("BouncyCastleProvider already added");
        }
        if (conf == null) {
            conf = SecurityConf.DEFAULT;
        }
        try {
            this.initSecurityFactory(conf);
        }
        catch (PasswordResolverException e) {
            LOG.error("could not initialize passwords", (Throwable)e);
            throw new InvalidConfException(e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.p11ModuleFactoryRegister != null) {
            try {
                this.p11ModuleFactoryRegister.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11ModuleFactoryRegister", th);
            }
            this.p11ModuleFactoryRegister = null;
        }
        if (this.p11CryptServiceFactory != null) {
            try {
                this.p11CryptServiceFactory.close();
            }
            catch (Throwable th) {
                LOG.error("error while closing P11CryptServiceFactory", th);
            }
            this.p11CryptServiceFactory = null;
        }
    }

    private void initSecurityFactory(SecurityConf conf) throws PasswordResolverException, InvalidConfException {
        Object factory;
        Class<?> clazz;
        Passwords passwords = new Passwords();
        passwords.init(conf.getPassword());
        this.securityFactory = new SecurityFactoryImpl();
        this.securityFactory.setStrongRandom4SignEnabled(conf.isSignStrongrandomEnabled());
        this.securityFactory.setStrongRandom4KeyEnabled(conf.isKeyStrongrandomEnabled());
        this.securityFactory.setDefaultSignerParallelism(conf.getDefaultSignerParallelism());
        this.securityFactory.setPasswordResolver(passwords.getPasswordResolver());
        SignerFactoryRegisterImpl signerFactoryRegister = new SignerFactoryRegisterImpl();
        this.securityFactory.setSignerFactoryRegister(signerFactoryRegister);
        KeypairGeneratorFactoryRegisterImpl keypairFactoryRegister = new KeypairGeneratorFactoryRegisterImpl();
        this.securityFactory.setKeypairGeneratorFactoryRegister(keypairFactoryRegister);
        P12SignerFactory p12SignerFactory = new P12SignerFactory();
        p12SignerFactory.setSecurityFactory(this.securityFactory);
        signerFactoryRegister.registFactory(p12SignerFactory);
        DfltKeypairGeneratorFactory dfltKeypairGeneratorFactory = new DfltKeypairGeneratorFactory();
        keypairFactoryRegister.registFactory(dfltKeypairGeneratorFactory);
        if (conf.getPkcs11Conf() != null) {
            this.initSecurityPkcs11(conf.getPkcs11Conf(), signerFactoryRegister, dfltKeypairGeneratorFactory, passwords.getPasswordResolver());
        }
        if (CollectionUtil.isNotEmpty(conf.getSignerFactories())) {
            for (String className : conf.getSignerFactories()) {
                try {
                    clazz = Class.forName(className);
                    factory = (SignerFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    signerFactoryRegister.registFactory((SignerFactory)factory);
                }
                catch (Exception ex) {
                    throw new InvalidConfException("error caught while initializing SignerFactory " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(conf.getKeypairGeneratorFactories())) {
            for (String className : conf.getKeypairGeneratorFactories()) {
                try {
                    clazz = Class.forName(className);
                    factory = (KeypairGeneratorFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    keypairFactoryRegister.registFactory((KeypairGeneratorFactory)factory);
                }
                catch (Exception ex) {
                    throw new InvalidConfException("error caught while initializing KeypairGeneratorFactory " + className + ": " + ex.getClass().getName() + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private void initSecurityPkcs11(FileOrValue pkcs11Conf, SignerFactoryRegisterImpl signerFactoryRegister, DfltKeypairGeneratorFactory dfltKeypairGeneratorFactory, PasswordResolver passwordResolver) throws InvalidConfException {
        Pkcs11conf pkcs11ConfObj;
        this.p11ModuleFactoryRegister = new P11ModuleFactoryRegisterImpl();
        for (P11ModuleFactory m : this.p11ModuleFactories) {
            this.p11ModuleFactoryRegister.registFactory(m);
        }
        this.p11CryptServiceFactory = new P11CryptServiceFactoryImpl(this.p11ModuleFactoryRegister);
        this.p11CryptServiceFactory.setPasswordResolver(passwordResolver);
        try {
            pkcs11ConfObj = JSON.parseObject(pkcs11Conf.readContent(), Pkcs11conf.class);
        }
        catch (IOException ex) {
            throw new InvalidConfException("could not create P11Conf: " + ex.getMessage(), (Throwable)ex);
        }
        this.p11CryptServiceFactory.setPkcs11Conf(pkcs11ConfObj);
        this.p11CryptServiceFactory.init();
        P11SignerFactory p11SignerFactory = new P11SignerFactory();
        p11SignerFactory.setSecurityFactory(this.securityFactory);
        p11SignerFactory.setP11CryptServiceFactory(this.p11CryptServiceFactory);
        signerFactoryRegister.registFactory(p11SignerFactory);
        dfltKeypairGeneratorFactory.setP11CryptServiceFactory(this.p11CryptServiceFactory);
    }

    public static class SecurityConf
    extends ValidatableConf {
        private boolean keyStrongrandomEnabled;
        private boolean signStrongrandomEnabled;
        private int defaultSignerParallelism = 32;
        private FileOrValue pkcs11Conf;
        private Passwords.PasswordConf password;
        private List<String> signerFactories;
        private List<String> keypairGeneratorFactories;
        public static final SecurityConf DEFAULT = new SecurityConf();

        public boolean isKeyStrongrandomEnabled() {
            return this.keyStrongrandomEnabled;
        }

        public void setKeyStrongrandomEnabled(boolean keyStrongrandomEnabled) {
            this.keyStrongrandomEnabled = keyStrongrandomEnabled;
        }

        public boolean isSignStrongrandomEnabled() {
            return this.signStrongrandomEnabled;
        }

        public void setSignStrongrandomEnabled(boolean signStrongrandomEnabled) {
            this.signStrongrandomEnabled = signStrongrandomEnabled;
        }

        public int getDefaultSignerParallelism() {
            return this.defaultSignerParallelism;
        }

        public void setDefaultSignerParallelism(int defaultSignerParallelism) {
            this.defaultSignerParallelism = defaultSignerParallelism;
        }

        public FileOrValue getPkcs11Conf() {
            return this.pkcs11Conf;
        }

        public void setPkcs11Conf(FileOrValue pkcs11Conf) {
            this.pkcs11Conf = pkcs11Conf;
        }

        public Passwords.PasswordConf getPassword() {
            return this.password == null ? Passwords.PasswordConf.DEFAULT : this.password;
        }

        public void setPassword(Passwords.PasswordConf password) {
            this.password = password;
        }

        public List<String> getSignerFactories() {
            return this.signerFactories;
        }

        public void setSignerFactories(List<String> signerFactories) {
            this.signerFactories = signerFactories;
        }

        public List<String> getKeypairGeneratorFactories() {
            return this.keypairGeneratorFactories;
        }

        public void setKeypairGeneratorFactories(List<String> keypairGeneratorFactories) {
            this.keypairGeneratorFactories = keypairGeneratorFactories;
        }

        public void validate() throws InvalidConfException {
        }
    }
}

