/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Set;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.KeypairGeneratorFactory;
import org.xipki.security.SecurityFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11KeypairGenerator;
import org.xipki.security.pkcs12.SoftwareKeypairGenerator;
import org.xipki.util.exception.ObjectCreationException;

public class DfltKeypairGeneratorFactory
implements KeypairGeneratorFactory {
    private static final String TYPE_SOFTWARE = "software";
    private static final String TYPE_PKCS11 = "pkcs11";
    private static final Set<String> types = Set.of("software", "pkcs11");
    private P11CryptServiceFactory p11CryptServiceFactory;

    public void setP11CryptServiceFactory(P11CryptServiceFactory p11CryptServiceFactory) {
        this.p11CryptServiceFactory = p11CryptServiceFactory;
    }

    @Override
    public Set<String> getSupportedKeypairTypes() {
        return types;
    }

    @Override
    public boolean canCreateKeypairGenerator(String type) {
        return types.contains(type.toLowerCase());
    }

    @Override
    public KeypairGenerator newKeypairGenerator(String type, String conf, SecurityFactory securityFactory) throws ObjectCreationException {
        if (!this.canCreateKeypairGenerator(type)) {
            throw new ObjectCreationException("unknown keypair generator type " + type);
        }
        KeypairGenerator kpGen = TYPE_SOFTWARE.equalsIgnoreCase(type) ? new SoftwareKeypairGenerator(securityFactory.getRandom4Key()) : new P11KeypairGenerator(this.p11CryptServiceFactory);
        try {
            kpGen.initialize(conf, securityFactory.getPasswordResolver());
        }
        catch (XiSecurityException ex) {
            throw new ObjectCreationException("error initializing keypairGen", (Throwable)ex);
        }
        return kpGen;
    }
}

