/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt.simple;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.XhtmlForm;
import org.xhtmlrenderer.simple.xhtml.XhtmlNamespaceHandler;
import org.xhtmlrenderer.simple.xhtml.controls.ButtonControl;
import org.xhtmlrenderer.simple.xhtml.controls.CheckControl;
import org.xhtmlrenderer.simple.xhtml.controls.SelectControl;
import org.xhtmlrenderer.simple.xhtml.controls.TextControl;
import org.xhtmlrenderer.swt.BasicRenderer;
import org.xhtmlrenderer.swt.FormControlReplacementElement;
import org.xhtmlrenderer.swt.SWTReplacedElementFactory;
import org.xhtmlrenderer.swt.simple.SWTButtonControl;
import org.xhtmlrenderer.swt.simple.SWTCheckControl;
import org.xhtmlrenderer.swt.simple.SWTFormControl;
import org.xhtmlrenderer.swt.simple.SWTSelectControl;
import org.xhtmlrenderer.swt.simple.SWTTextControl;
import org.xhtmlrenderer.swt.simple.SWTXhtmlControl;

@ParametersAreNonnullByDefault
public class SWTXhtmlReplacedElementFactory
extends SWTReplacedElementFactory {
    private final BasicRenderer _parent;
    private final Map<Element, XhtmlForm> _forms = new HashMap<Element, XhtmlForm>();
    private final Map<Element, ReplacedElement> _controls = new HashMap<Element, ReplacedElement>();

    public SWTXhtmlReplacedElementFactory(BasicRenderer parent) {
        this._parent = parent;
    }

    @Nullable
    @CheckReturnValue
    public XhtmlForm getForm(Element e) {
        return this._forms.get(e);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        NamespaceHandler namespaceHandler;
        ReplacedElement re = super.createReplacedElement(c, box, uac, cssWidth, cssHeight);
        if (re == null && (namespaceHandler = c.getNamespaceHandler()) instanceof XhtmlNamespaceHandler) {
            XhtmlNamespaceHandler nsh = (XhtmlNamespaceHandler)namespaceHandler;
            if (!c.isPrint()) {
                SWTXhtmlControl swtControl;
                FormControl control;
                Element e = box.getElement();
                if (e == null) {
                    return null;
                }
                re = this._controls.get(e);
                if (re != null) {
                    if (re instanceof FormControlReplacementElement) {
                        ((FormControlReplacementElement)re).calculateSize(c, box.getStyle(), cssWidth, cssHeight);
                    }
                    return re;
                }
                Element parentForm = this.getParentForm(e, c);
                XhtmlForm form = this._forms.get(parentForm);
                if (form == null) {
                    form = nsh.createForm(parentForm);
                    this._forms.put(parentForm, form);
                }
                if ((control = form.createControl(e)) == null) {
                    return null;
                }
                if (control instanceof TextControl) {
                    swtControl = new SWTTextControl(control, this._parent, c, box.getStyle(), uac);
                } else if (control instanceof ButtonControl) {
                    swtControl = new SWTButtonControl(control, this._parent, c, box.getStyle(), uac);
                } else if (control instanceof CheckControl) {
                    swtControl = new SWTCheckControl(control, this._parent, c, box.getStyle(), uac);
                } else if (control instanceof SelectControl) {
                    swtControl = new SWTSelectControl(control, this._parent, c, box.getStyle(), uac);
                } else {
                    return null;
                }
                swtControl.getSWTControl().setVisible(false);
                FormControlReplacementElement element = new FormControlReplacementElement(swtControl);
                element.calculateSize(c, box.getStyle(), cssWidth, cssHeight);
                re = element;
                this._controls.put(e, re);
            }
        }
        return re;
    }

    @Override
    public void remove(Element e) {
        SWTFormControl control;
        super.remove(e);
        ReplacedElement re = this._controls.get(e);
        if (re instanceof FormControlReplacementElement && (control = ((FormControlReplacementElement)re).getControl()) != null) {
            control.dispose();
        }
        this._controls.remove(e);
    }

    @Override
    public void reset() {
        super.reset();
        this._forms.clear();
        for (ReplacedElement re : this._controls.values()) {
            SWTFormControl control;
            if (!(re instanceof FormControlReplacementElement) || (control = ((FormControlReplacementElement)re).getControl()) == null) continue;
            control.dispose();
        }
        this._controls.clear();
    }

    @Nullable
    @CheckReturnValue
    protected Element getParentForm(Element e, LayoutContext context) {
        Node node = e;
        XhtmlNamespaceHandler nsh = (XhtmlNamespaceHandler)context.getNamespaceHandler();
        while ((node = node.getParentNode()).getNodeType() == 1 && !nsh.isFormElement((Element)node)) {
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return (Element)node;
    }
}

