/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt.simple;

import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormControlAdapter;
import org.xhtmlrenderer.simple.xhtml.FormControlListener;
import org.xhtmlrenderer.simple.xhtml.controls.TextControl;
import org.xhtmlrenderer.swt.BasicRenderer;
import org.xhtmlrenderer.swt.simple.SWTXhtmlControl;

public class SWTTextControl
extends SWTXhtmlControl {
    private static final Pattern RE_NEWLINE = Pattern.compile("\n");
    private String _sizeText;
    private boolean _noChangeText = false;

    public SWTTextControl(FormControl control, BasicRenderer parent, LayoutContext c, CalculatedStyle style, UserAgentCallback uac) {
        super(control, parent, c, style, uac);
    }

    @Override
    protected Control createSWTControl(FormControl control, BasicRenderer parent, LayoutContext c, CalculatedStyle style, UserAgentCallback uac) {
        TextControl tc = (TextControl)control;
        int sty = 2048;
        if (tc.isMultiLine()) {
            sty |= 2;
        }
        if (tc.isReadOnly()) {
            sty |= 8;
        }
        if (tc.isPassword()) {
            sty |= 0x400000;
        }
        final Text text = new Text((Composite)parent, sty);
        text.setText(SWTTextControl.encodeDelimiter(control.getInitialValue()));
        StringBuilder str = new StringBuilder(tc.getSize());
        str.append("M".repeat(Math.max(0, tc.getSize())));
        if (tc.isMultiLine()) {
            str.append(Text.DELIMITER.repeat(Math.max(0, tc.getRows() - 1)));
        }
        this._sizeText = str.toString();
        if (tc.getMaxLength() >= 0) {
            text.setTextLimit(tc.getMaxLength());
        }
        tc.addFormControlListener((FormControlListener)new FormControlAdapter(){

            public void changed(FormControl control) {
                if (!SWTTextControl.this._noChangeText) {
                    text.setText(SWTTextControl.encodeDelimiter(control.getValue()));
                }
                SWTTextControl.this._noChangeText = false;
            }
        });
        text.addModifyListener(e -> {
            this._noChangeText = true;
            tc.setValue(SWTTextControl.decodeDelimiter(text.getText()));
        });
        return text;
    }

    @Override
    public int getIdealWidth() {
        Text text = (Text)this.getSWTControl();
        String old = text.getText();
        text.setText(this._sizeText);
        text.pack();
        int width = text.getSize().x;
        text.setText(old);
        return width;
    }

    @Override
    public int getIdealHeight() {
        Text text = (Text)this.getSWTControl();
        String old = text.getText();
        text.setText(this._sizeText);
        text.pack();
        int height = text.getSize().y;
        text.setText(old);
        return height;
    }

    private static String encodeDelimiter(String text) {
        return RE_NEWLINE.matcher(text).replaceAll(Text.DELIMITER);
    }

    private static String decodeDelimiter(String text) {
        return text.replaceAll(Text.DELIMITER, "\n");
    }
}

