/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swt.SWTFSImage;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class NaiveUserAgent
implements UserAgentCallback {
    private final int _imageCacheCapacity = 16;
    private final Map<String, ImageResource> _imageCache = new LinkedHashMap<String, ImageResource>(16, 0.75f, true);
    private @Nullable String _baseURL;
    private final Device _device;

    public NaiveUserAgent(Device device) {
        this._device = device;
    }

    public CSSResource getCSSResource(String uri) {
        return new CSSResource(IOUtil.getInputStream((String)this.resolveURI(uri)));
    }

    public ImageResource getImageResource(String uri) {
        if (ImageUtil.isEmbeddedBase64Image((String)uri)) {
            return this.loadEmbeddedBase64ImageResource(uri);
        }
        ImageResource ir = this._imageCache.get(uri = this.resolveURI(uri));
        if (ir == null) {
            try (InputStream is = IOUtil.getInputStream((String)this.resolveURI(uri));){
                if (is != null) {
                    ir = this.createImageResource(uri, is);
                    if (this._imageCache.size() >= 16) {
                        ImageResource old = this._imageCache.remove(this._imageCache.keySet().iterator().next());
                        ((SWTFSImage)old.getImage()).getImage().dispose();
                    }
                    this._imageCache.put(uri, ir);
                }
            }
            catch (IOException | SWTException e) {
                XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
            }
        }
        if (ir == null) {
            ir = new ImageResource(uri, null);
        }
        return ir;
    }

    protected ImageResource createImageResource(@Nullable String uri, InputStream is) {
        return new ImageResource(uri, (FSImage)new SWTFSImage(new Image(this._device, is), this, uri));
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        byte[] image = ImageUtil.getEmbeddedBase64Image((String)uri);
        if (image != null) {
            return this.createImageResource(null, new ByteArrayInputStream(image));
        }
        return new ImageResource(null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLResource getXMLResource(String uri) {
        if (uri == null) {
            XRLog.exception((String)"null uri requested");
            return null;
        }
        try (InputStream inputStream = IOUtil.getInputStream((String)this.resolveURI(uri));){
            if (inputStream == null) {
                XRLog.exception((String)("couldn't get InputStream for " + uri));
                XMLResource xMLResource2 = null;
                return xMLResource2;
            }
            XMLResource xMLResource = XMLResource.load((InputStream)inputStream);
            return xMLResource;
        }
        catch (Exception e) {
            XRLog.exception((String)("unable to load xml resource: " + uri), (Throwable)e);
            return null;
        }
    }

    public boolean isVisited(String uri) {
        return false;
    }

    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    @CheckReturnValue
    public @Nullable String resolveURI(@Nullable String uri) {
        Exception t;
        if (uri == null) {
            return null;
        }
        if (this._baseURL == null) {
            try {
                URI result = new URI(uri);
                if (result.isAbsolute()) {
                    this.setBaseURL(result.toString());
                }
            }
            catch (URISyntaxException e) {
                XRLog.exception((String)("The default NaiveUserAgent could not use the URL as base url: " + uri), (Throwable)e);
            }
            if (this._baseURL == null) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (IOException e) {
                    XRLog.exception((String)"The default NaiveUserAgent doesn't know how to resolve the base URL for %s (caused by: %s)".formatted(uri, e));
                    return null;
                }
            }
        }
        try {
            URI result = new URI(uri);
            if (result.isAbsolute()) {
                return result.toString();
            }
            XRLog.load((String)(uri + " is not a URL; may be relative. Testing using parent URL " + this._baseURL));
            URI baseURI = new URI(this._baseURL);
            if (!baseURI.isOpaque()) {
                return baseURI.resolve(result).toString();
            }
            try {
                return new URL(new URL(this._baseURL), uri).toExternalForm();
            }
            catch (MalformedURLException ex) {
                t = ex;
            }
        }
        catch (URISyntaxException e) {
            t = e;
        }
        XRLog.exception((String)("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL), (Throwable)t);
        return null;
    }

    @CheckReturnValue
    public @Nullable String getBaseURL() {
        return this._baseURL;
    }

    public void disposeCache() {
        for (ImageResource ir : this._imageCache.values()) {
            ((SWTFSImage)ir.getImage()).getImage().dispose();
        }
        this._imageCache.clear();
    }

    @CheckReturnValue
    public byte @Nullable [] getBinaryResource(String uri) {
        return IOUtil.readBytes((String)this.resolveURI(uri));
    }
}

