/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.xhtmlrenderer.extend.FSGlyphVector;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.swt.SWTFSFont;
import org.xhtmlrenderer.swt.SWTFontContext;
import org.xhtmlrenderer.swt.SWTFontMetricsAdapter;
import org.xhtmlrenderer.swt.SWTOutputDevice;
import org.xhtmlrenderer.util.Configuration;

public class SWTTextRenderer
implements TextRenderer {
    private float _scale = Configuration.valueAsFloat((String)"xr.text.scale", (float)1.0f);
    private boolean _antialiasing;

    public SWTTextRenderer() {
        this.setSmoothingThreshold(Configuration.valueAsInt((String)"xr.text.aa-fontsize-threshhold", (int)0));
    }

    public void setup(FontContext context) {
        GC gc = ((SWTFontContext)context).getGC();
        gc.setTextAntialias(this._antialiasing ? 1 : 0);
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        GC gc = ((SWTOutputDevice)outputDevice).getGC();
        FontMetrics metrics = gc.getFontMetrics();
        gc.drawText(string, (int)x, (int)(y -= (float)(metrics.getAscent() + metrics.getLeading())), 1);
    }

    @CheckReturnValue
    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        return new SWTFontMetricsAdapter((SWTFontContext)context, (SWTFSFont)font);
    }

    public int getWidth(FontContext context, FSFont font, String string) {
        GC gc = ((SWTFontContext)context).getGC();
        Font previous = gc.getFont();
        gc.setFont(((SWTFSFont)font).getSWTFont());
        int width = gc.stringExtent((String)string).x;
        gc.setFont(previous);
        return width;
    }

    public float getFontScale() {
        return this._scale;
    }

    public void setFontScale(float scale) {
        this._scale = scale;
    }

    public void setSmoothingThreshold(float fontsize) {
        this._antialiasing = fontsize >= 0.0f;
    }

    public void drawGlyphVector(OutputDevice outputDevice, FSGlyphVector vector, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: drawGlyphVector");
    }

    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        this.drawString(outputDevice, string, x, y);
    }

    public Rectangle getGlyphBounds(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector, int index, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphBounds");
    }

    public float[] getGlyphPositions(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphPositions");
    }

    public FSGlyphVector getGlyphVector(OutputDevice outputDevice, FSFont font, String string) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphVector");
    }
}

