/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.DefaultFormSubmissionListener;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.swt.ImageReplacedElement;
import org.xhtmlrenderer.swt.SWTFSImage;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class SWTReplacedElementFactory
implements ReplacedElementFactory {
    private Map _imageComponents;
    private FormSubmissionListener _formSubmissionListener = new DefaultFormSubmissionListener();

    public void clean() {
        this.reset();
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        if (c.getNamespaceHandler().isImageElement(e)) {
            return this.replaceImage(uac, c, e, cssWidth, cssHeight);
        }
        return null;
    }

    protected ReplacedElement replaceImage(UserAgentCallback uac, LayoutContext context, Element elem, int cssWidth, int cssHeight) {
        ReplacedElement re = null;
        String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
        if (imageSrc == null || imageSrc.length() == 0) {
            XRLog.layout((Level)Level.WARNING, (String)"No source provided for img element.");
            re = new ImageReplacedElement(new SWTFSImage(), cssWidth, cssHeight);
        } else if (ImageUtil.isEmbeddedBase64Image((String)imageSrc)) {
            SWTFSImage fsImage = (SWTFSImage)uac.getImageResource(imageSrc).getImage();
            if (fsImage != null) {
                re = new ImageReplacedElement(fsImage, cssWidth, cssHeight);
            }
        } else {
            re = this.lookupImageReplacedElement(elem);
            if (re == null) {
                FSImage fsImage = uac.getImageResource(imageSrc).getImage();
                re = fsImage != null ? new ImageReplacedElement(new SWTFSImage((SWTFSImage)fsImage), cssWidth, cssHeight) : new ImageReplacedElement(new SWTFSImage(), cssWidth, cssHeight);
                this.storeImageReplacedElement(elem, re);
            }
        }
        return re;
    }

    protected void storeImageReplacedElement(Element e, ReplacedElement cc) {
        if (this._imageComponents == null) {
            this._imageComponents = new HashMap();
        }
        this._imageComponents.put(e, cc);
    }

    protected ReplacedElement lookupImageReplacedElement(Element e) {
        if (this._imageComponents == null) {
            return null;
        }
        return (ReplacedElement)this._imageComponents.get(e);
    }

    public void remove(Element e) {
        if (this._imageComponents != null) {
            this._imageComponents.remove(e);
        }
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
        this._formSubmissionListener = listener;
    }

    public void reset() {
        this._imageComponents = null;
    }
}

