/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.xhtml.XhtmlForm;
import org.xhtmlrenderer.simple.xhtml.XhtmlNamespaceHandler;
import org.xhtmlrenderer.simple.xhtml.swt.SWTXhtmlReplacedElementFactory;
import org.xhtmlrenderer.swt.BasicRenderer;
import org.xhtmlrenderer.swt.CursorListener;
import org.xhtmlrenderer.swt.HoverListener;
import org.xhtmlrenderer.swt.LinkListener;
import org.xhtmlrenderer.util.Configuration;

public class SWTXHTMLRenderer
extends BasicRenderer {
    public SWTXHTMLRenderer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public SWTXHTMLRenderer(Composite parent, int style, UserAgentCallback uac) {
        super(parent, style, uac);
        this.init();
    }

    protected void init() {
        this.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new SWTXhtmlReplacedElementFactory(this));
        if (Configuration.isTrue((String)"xr.use.listeners", (boolean)true)) {
            new HoverListener(this);
            new CursorListener(this);
            new LinkListener(this);
        }
    }

    @Override
    public void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    public void setDocument(Document doc) {
        this.setDocument(doc, "");
    }

    @Override
    public void setDocument(Document doc, String url) {
        super.setDocument(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    @Override
    public void setDocument(InputStream stream, String url) {
        super.setDocument(stream, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    public void setDocument(File file) throws MalformedURLException {
        File parent = file.getParentFile();
        String parentURL = parent == null ? "" : parent.toURI().toURL().toExternalForm();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parentURL);
    }

    public XhtmlForm getForm(Element e) {
        ReplacedElementFactory ref = this.getSharedContext().getReplacedElementFactory();
        if (ref != null && ref instanceof SWTXhtmlReplacedElementFactory) {
            return ((SWTXhtmlReplacedElementFactory)ref).getForm(e);
        }
        return null;
    }
}

