/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swt.SWTFSImage;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class NaiveUserAgent
implements UserAgentCallback {
    private int _imageCacheCapacity = 16;
    private LinkedHashMap _imageCache = new LinkedHashMap(this._imageCacheCapacity, 0.75f, true);
    private String _baseURL;
    private final Device _device;

    public NaiveUserAgent(Device device) {
        this._device = device;
    }

    protected InputStream getInputStream(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            is = new URL(uri).openStream();
        }
        catch (MalformedURLException e) {
            XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            XRLog.exception((String)("item at URI " + uri + " not found"));
        }
        catch (IOException e) {
            XRLog.exception((String)("IO problem for " + uri), (Throwable)e);
        }
        return is;
    }

    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.getInputStream(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getImageResource(String uri) {
        ImageResource ir = null;
        if (ImageUtil.isEmbeddedBase64Image((String)uri)) {
            ir = this.loadEmbeddedBase64ImageResource(uri);
        } else {
            InputStream is;
            ir = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
            if (ir == null && (is = this.getInputStream(uri)) != null) {
                try {
                    ir = this.createImageResource(uri, is);
                    if (this._imageCache.size() >= this._imageCacheCapacity) {
                        ImageResource old = (ImageResource)this._imageCache.remove(this._imageCache.keySet().iterator().next());
                        ((SWTFSImage)old.getImage()).getImage().dispose();
                    }
                    this._imageCache.put(uri, ir);
                }
                catch (SWTException e) {
                    XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (ir == null) {
                ir = new ImageResource(uri, null);
            }
        }
        return ir;
    }

    protected ImageResource createImageResource(String uri, InputStream is) {
        return new ImageResource(uri, (FSImage)new SWTFSImage(new Image(this._device, is), this, uri));
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        byte[] image = ImageUtil.getEmbeddedBase64Image((String)uri);
        if (image != null) {
            return this.createImageResource(null, new ByteArrayInputStream(image));
        }
        return new ImageResource(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        if (uri == null) {
            XRLog.exception((String)"null uri requested");
            return null;
        }
        InputStream inputStream = this.getInputStream(uri);
        if (inputStream == null) {
            XRLog.exception((String)("couldn't get InputStream for " + uri));
            return null;
        }
        try {
            xmlResource = XMLResource.load((InputStream)inputStream);
        }
        catch (Exception e) {
            XRLog.exception((String)("unable to load xml resource: " + uri), (Throwable)e);
            XMLResource xMLResource = null;
            return xMLResource;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return xmlResource;
    }

    public boolean isVisited(String uri) {
        return false;
    }

    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    public String resolveURI(String uri) {
        URI result;
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this._baseURL == null) {
            try {
                result = new URI(uri);
                if (result.isAbsolute()) {
                    this.setBaseURL(result.toString());
                }
            }
            catch (URISyntaxException e) {
                XRLog.exception((String)("The default NaiveUserAgent could not use the URL as base url: " + uri), (Throwable)e);
            }
            if (this._baseURL == null) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.exception((String)("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri));
                    return null;
                }
            }
        }
        try {
            result = new URI(uri);
            if (!result.isAbsolute()) {
                XRLog.load((String)(uri + " is not a URL; may be relative. Testing using parent URL " + this._baseURL));
                result = new URI(this._baseURL).resolve(result);
            }
            ret = result.toString();
        }
        catch (URISyntaxException e) {
            XRLog.exception((String)("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL));
        }
        return ret;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public void disposeCache() {
        Iterator iter = this._imageCache.values().iterator();
        while (iter.hasNext()) {
            ImageResource ir = (ImageResource)iter.next();
            ((SWTFSImage)ir.getImage()).getImage().dispose();
        }
        this._imageCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(String uri) {
        InputStream is = this.getInputStream(uri);
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

