/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.swt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormControlAdapter;
import org.xhtmlrenderer.simple.xhtml.FormControlListener;
import org.xhtmlrenderer.simple.xhtml.controls.SelectControl;
import org.xhtmlrenderer.simple.xhtml.swt.SWTXhtmlControl;
import org.xhtmlrenderer.swt.BasicRenderer;

public class SWTSelectControl
extends SWTXhtmlControl {
    private boolean _combo;
    private List _values;
    private List _labels;

    public SWTSelectControl(FormControl control, BasicRenderer parent, LayoutContext c, CalculatedStyle style, UserAgentCallback uac) {
        super(control, parent, c, style, uac);
    }

    protected Control createSWTControl(FormControl control, BasicRenderer parent, LayoutContext c, CalculatedStyle style, UserAgentCallback uac) {
        final SelectControl sc = (SelectControl)control;
        Map options = sc.getOptions();
        this._values = new ArrayList(options.keySet());
        this._labels = new ArrayList(options.values());
        if (sc.getSize() > 1 || sc.isMultiple()) {
            this._combo = false;
            final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)parent, 0xA00 | (sc.isMultiple() ? 2 : 4));
            list.setItems(this._labels.toArray(new String[this._labels.size()]));
            list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (sc.isMultiple()) {
                        int[] indices = list.getSelectionIndices();
                        String[] values = new String[indices.length];
                        for (int i = 0; i < indices.length; ++i) {
                            values[i] = (String)SWTSelectControl.this._values.get(indices[i]);
                        }
                        sc.setMultipleValues(values);
                    } else {
                        sc.setValue((String)SWTSelectControl.this._values.get(list.getSelectionIndex()));
                    }
                }
            });
            sc.addFormControlListener((FormControlListener)new FormControlAdapter(){

                public void changed(FormControl control) {
                    if (sc.isSuccessful()) {
                        if (sc.isMultiple()) {
                            String[] values = sc.getMultipleValues();
                            int[] indices = new int[values.length];
                            for (int i = 0; i < values.length; ++i) {
                                indices[i] = SWTSelectControl.this._values.indexOf(values[i]);
                            }
                            list.setSelection(indices);
                        } else {
                            list.setSelection(SWTSelectControl.this._values.indexOf(sc.getValue()));
                        }
                    } else {
                        list.deselectAll();
                    }
                }

                public void successful(FormControl control) {
                    this.changed(control);
                }
            });
            if (sc.isSuccessful()) {
                if (sc.isMultiple()) {
                    String[] values = sc.getMultipleValues();
                    int[] indices = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        indices[i] = this._values.indexOf(values[i]);
                    }
                    list.setSelection(indices);
                } else {
                    list.setSelection(this._values.indexOf(sc.getValue()));
                }
            }
            return list;
        }
        this._combo = true;
        final Combo combo = new Combo((Composite)parent, 12);
        combo.setItems(this._labels.toArray(new String[this._labels.size()]));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = combo.getSelectionIndex();
                if (selection < 0) {
                    sc.setSuccessful(false);
                } else {
                    sc.setValue((String)SWTSelectControl.this._values.get(selection));
                }
            }
        });
        sc.addFormControlListener((FormControlListener)new FormControlAdapter(){

            public void changed(FormControl control) {
                if (sc.isSuccessful()) {
                    combo.select(SWTSelectControl.this._values.indexOf(sc.getValue()));
                } else {
                    combo.deselectAll();
                }
            }

            public void successful(FormControl control) {
                this.changed(control);
            }
        });
        if (sc.isSuccessful()) {
            combo.select(this._values.indexOf(sc.getValue()));
        }
        return combo;
    }

    public int getIdealHeight() {
        if (this._combo) {
            this.getSWTControl().pack();
            return this.getSWTControl().getSize().y;
        }
        SelectControl sc = (SelectControl)this.getFormControl();
        org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)this.getSWTControl();
        String[] oldSelection = list.getSelection();
        String[] oldItems = list.getItems();
        String[] items = new String[sc.getSize()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = "Gg";
        }
        list.setItems(items);
        list.pack();
        int height = list.getSize().y;
        list.setItems(oldItems);
        list.setSelection(oldSelection);
        return height;
    }

    public int getIdealWidth() {
        this.getSWTControl().pack();
        return this.getSWTControl().getSize().x;
    }
}

