/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import com.google.errorprone.annotations.CheckReturnValue;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.UserAgentCallback;

public class SWTFSImage
implements FSImage {
    private final @Nullable UserAgentCallback _uac;
    private final @Nullable String _uri;
    private @Nullable Image _image;
    private int _width;
    private int _height;

    public SWTFSImage() {
        this(null, null, null);
    }

    public SWTFSImage(@Nullable Image image, @Nullable UserAgentCallback uac, @Nullable String uri) {
        this._uac = uac;
        this._uri = uri;
        this._image = image;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            this._width = bounds.width;
            this._height = bounds.height;
        } else {
            this._width = 10;
            this._height = 10;
        }
    }

    private SWTFSImage(@Nullable Image image, @Nullable UserAgentCallback uac, @Nullable String uri, int width, int height) {
        this._uac = uac;
        this._uri = uri;
        this._image = image;
        this._width = width;
        this._height = height;
    }

    public SWTFSImage(SWTFSImage image) {
        this._uac = image._uac;
        this._uri = image._uri;
        this._image = image._image;
        this._width = image._width;
        this._height = image._height;
    }

    public @Nullable Image getImage() {
        if (this._image != null && this._image.isDisposed()) {
            SWTFSImage image = (SWTFSImage)this._uac.getImageResource(this._uri).getImage();
            this._image = image == null ? null : image._image;
        }
        return this._image;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        if (height < 0) {
            return;
        }
        this._height = height;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        if (width < 0) {
            return;
        }
        this._width = width;
    }

    @CheckReturnValue
    public SWTFSImage scale(int width, int height) {
        if (width < 0 && height < 0) {
            return this;
        }
        if (width < 0) {
            width = Math.round((float)this._width * (this._height == 0 ? 1.0f : (float)height / (float)this._height));
        } else if (height < 0) {
            height = Math.round((float)this._height * (this._width == 0 ? 1.0f : (float)width / (float)this._width));
        }
        return new SWTFSImage(this._image, this._uac, this._uri, width, height);
    }
}

