/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.xhtmlrenderer.extend.FSGlyphVector;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.swt.SWTFSFont;
import org.xhtmlrenderer.swt.SWTFontContext;
import org.xhtmlrenderer.swt.SWTFontMetricsAdapter;
import org.xhtmlrenderer.swt.SWTOutputDevice;
import org.xhtmlrenderer.util.Configuration;

public final class SWTTextRenderer
implements TextRenderer<SWTOutputDevice, SWTFontContext, SWTFSFont> {
    private float _scale = Configuration.valueAsFloat((String)"xr.text.scale", (float)1.0f);
    private boolean _antialiasing = false;

    public SWTTextRenderer() {
        this.setSmoothingThreshold(Configuration.valueAsInt((String)"xr.text.aa-fontsize-threshhold", (int)0));
    }

    public void setup(SWTFontContext context) {
        GC gc = context.getGC();
        gc.setTextAntialias(this._antialiasing ? 1 : 0);
    }

    public void drawString(SWTOutputDevice outputDevice, String string, float x, float y) {
        GC gc = outputDevice.getGC();
        FontMetrics metrics = gc.getFontMetrics();
        gc.drawText(string, (int)x, (int)(y -= (float)(metrics.getAscent() + metrics.getLeading())), 1);
    }

    @CheckReturnValue
    public FSFontMetrics getFSFontMetrics(SWTFontContext context, SWTFSFont font, String string) {
        return new SWTFontMetricsAdapter(context, font);
    }

    public int getWidth(SWTFontContext context, SWTFSFont font, String string) {
        GC gc = context.getGC();
        Font previous = gc.getFont();
        gc.setFont(font.getSWTFont());
        int width = gc.stringExtent((String)string).x;
        gc.setFont(previous);
        return width;
    }

    public float getFontScale() {
        return this._scale;
    }

    public void setFontScale(float scale) {
        this._scale = scale;
    }

    public void setSmoothingThreshold(float fontsize) {
        this._antialiasing = fontsize >= 0.0f;
    }

    public void drawGlyphVector(SWTOutputDevice outputDevice, FSGlyphVector vector, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: drawGlyphVector");
    }

    public void drawString(SWTOutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        this.drawString(outputDevice, string, x, y);
    }

    public Rectangle getGlyphBounds(SWTOutputDevice outputDevice, SWTFSFont font, FSGlyphVector fsGlyphVector, int index, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphBounds");
    }

    public float[] getGlyphPositions(SWTOutputDevice outputDevice, SWTFSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphPositions");
    }

    public FSGlyphVector getGlyphVector(SWTOutputDevice outputDevice, SWTFSFont font, String string) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphVector");
    }
}

